/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.graphics.GraphicSVG;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.text.ParseException;
import de.neemann.digital.draw.graphics.text.Parser;
import de.neemann.digital.draw.graphics.text.formatter.LaTeXFormatter;
import de.neemann.digital.draw.graphics.text.text.Decorate;
import de.neemann.digital.draw.graphics.text.text.Text;
import java.util.ArrayList;

public class TextFormatLaTeX
implements GraphicSVG.TextStyle {
    private static final ArrayList<FontSize> FONT_SIZES = new ArrayList();
    private boolean pinStyleInMathMode;

    public TextFormatLaTeX(boolean pinStyleInMathMode) {
        this.pinStyleInMathMode = pinStyleInMathMode;
    }

    private static void add(String name, int size) {
        FONT_SIZES.add(new FontSize(name, size * Style.NORMAL.getFontSize() / 63));
    }

    private static String getFontSizeName(int fontSize) {
        String best = "normalsize";
        int diff = Integer.MAX_VALUE;
        for (FontSize fs : FONT_SIZES) {
            int d = Math.abs(fontSize - fs.size);
            if (d >= diff) continue;
            diff = d;
            best = fs.name;
        }
        return best;
    }

    @Override
    public String format(String text, Style style) {
        String fontSizeName;
        try {
            boolean decorate;
            Text t = new Parser(text).parse();
            boolean bl = decorate = style.getFontStyle() == 2;
            if (style == Style.INOUT && !this.pinStyleInMathMode) {
                decorate = false;
            } else if (style == Style.SHAPE_PIN && this.pinStyleInMathMode) {
                decorate = true;
            }
            if (decorate) {
                t = Decorate.math(t);
            }
            text = LaTeXFormatter.format(t);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (style.getFontSize() != Style.NORMAL.getFontSize() && !(fontSizeName = TextFormatLaTeX.getFontSizeName(style.getFontSize())).equals("normalsize")) {
            text = "{\\" + fontSizeName + " " + text + "}";
        }
        return GraphicSVG.escapeXML(text);
    }

    static {
        TextFormatLaTeX.add("tiny", 35);
        TextFormatLaTeX.add("scriptsize", 46);
        TextFormatLaTeX.add("footnotesize", 52);
        TextFormatLaTeX.add("small", 58);
        TextFormatLaTeX.add("normalsize", 63);
        TextFormatLaTeX.add("large", 69);
        TextFormatLaTeX.add("Large", 83);
        TextFormatLaTeX.add("LARGE", 100);
        TextFormatLaTeX.add("huge", 120);
        TextFormatLaTeX.add("Huge", 143);
    }

    private static final class FontSize {
        private final String name;
        private final int size;

        private FontSize(String name, int size) {
            this.name = name;
            this.size = size;
        }
    }
}

