/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.core.Value;
import de.neemann.digital.draw.graphics.ColorKey;
import de.neemann.digital.draw.graphics.ColorScheme;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;

public final class Style {
    public static final int MAXLINETHICK = 4;
    private static final int LINETHIN = 2;
    private static final int WIRETHICK = 4;
    private static final int LINETHICK = 4;
    private static final int LINEDASH = 1;
    public static final Style NORMAL = Builder.access$100(new Builder());
    public static final Style DISABLED = Builder.access$100(Builder.access$200(new Builder(), ColorKey.DISABLED));
    public static final Style INOUT = Builder.access$100(Builder.access$400(new Builder(NORMAL), 2));
    public static final Style FAILED = Builder.access$100(Builder.access$200(new Builder(NORMAL), ColorKey.ERROR));
    public static final Style PASS = Builder.access$100(Builder.access$200(new Builder(NORMAL), ColorKey.PASSED));
    public static final Style NORMAL_TEXT = Builder.access$100(Builder.access$500(new Builder(NORMAL), true));
    public static final Style THIN = Builder.access$100(Builder.access$600(new Builder(NORMAL), 2));
    public static final Style THIN_FILLED = Builder.access$100(Builder.access$700(Builder.access$600(new Builder(NORMAL), 2), true));
    public static final Style THICK = Builder.access$100(Builder.access$600(new Builder(NORMAL), 6));
    public static final Style WIRE = Builder.access$100(Builder.access$800(Builder.access$200(Builder.access$700(Builder.access$600(new Builder(), 4), true), ColorKey.WIRE), 1));
    public static final Style WIRE_LOW = Builder.access$100(Builder.access$200(new Builder(WIRE), ColorKey.WIRE_LOW));
    public static final Style WIRE_HIGH = Builder.access$100(Builder.access$200(new Builder(WIRE), ColorKey.WIRE_HIGH));
    public static final Style WIRE_HIGHZ = Builder.access$100(Builder.access$200(new Builder(WIRE), ColorKey.WIRE_Z));
    public static final Style WIRE_OUT = Builder.access$100(Builder.access$200(new Builder(WIRE), ColorKey.WIRE_OUT));
    public static final Style FILLED = Builder.access$100(Builder.access$700(new Builder(), true));
    public static final Style DASH = Builder.access$100(Builder.access$900(Builder.access$600(new Builder(), 1), new float[]{4.0f, 4.0f}));
    public static final Style SHAPE_PIN = Builder.access$100(Builder.access$1000(Builder.access$200(Builder.access$600(new Builder(), 2), ColorKey.PINS), 18));
    public static final Style SHAPE_SPLITTER = Builder.access$100(Builder.access$1000(new Builder(SHAPE_PIN), 12));
    public static final Style WIRE_VALUE = Builder.access$100(Builder.access$200(new Builder(SHAPE_SPLITTER), ColorKey.WIRE_VALUE));
    public static final Style WIRE_BITS = Builder.access$100(Builder.access$200(new Builder(SHAPE_SPLITTER), ColorKey.WIRE));
    public static final Style HIGHLIGHT = Builder.access$100(Builder.access$800(Builder.access$200(new Builder(NORMAL), ColorKey.HIGHLIGHT), 1));
    public static final Style ERROR = Builder.access$100(Builder.access$800(Builder.access$200(new Builder(NORMAL), ColorKey.ERROR), 1));
    private final int thickness;
    private final boolean filled;
    private final Color color;
    private final ColorKey colorKey;
    private final int fontSize;
    private final float[] dash;
    private final BasicStroke stroke;
    private final Font font;
    private final boolean mattersForSize;
    private final int fontStyle;

    private Style(Builder builder) {
        this.thickness = builder.thickness;
        this.filled = builder.filled;
        this.colorKey = builder.colorKey;
        this.color = builder.color;
        this.fontSize = builder.fontSize;
        this.fontStyle = builder.fontStyle;
        this.dash = builder.dash;
        this.mattersForSize = builder.mattersForSize;
        this.stroke = new BasicStroke(this.thickness, builder.endCap, 0, 10.0f, this.dash, 0.0f);
        this.font = new Font(null, this.fontStyle, this.fontSize);
    }

    public int getThickness() {
        return this.thickness;
    }

    boolean isFilled() {
        return this.filled;
    }

    public Color getColor() {
        if (this.colorKey != null) {
            return ColorScheme.getSelected().getColor(this.colorKey);
        }
        return this.color;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public Font getFont() {
        return this.font;
    }

    float[] getDash() {
        return this.dash;
    }

    public static Style getWireStyle(Value value) {
        if (value == null || value.getBits() > 1) {
            return WIRE;
        }
        if (value.isHighZ()) {
            return WIRE_HIGHZ;
        }
        if (value.getValue() == 1L) {
            return WIRE_HIGH;
        }
        return WIRE_LOW;
    }

    boolean mattersAlwaysForSize() {
        return this.mattersForSize;
    }

    public Style deriveFontStyle(int fontSize, boolean mattersForSize) {
        return new Builder(this).setFontSize(fontSize).setMattersForSize(mattersForSize).build();
    }

    public Style deriveColor(Color color) {
        return new Builder(this).setColor(color).build();
    }

    public Style deriveColor(ColorKey colorKey) {
        return new Builder(this).setColor(colorKey).build();
    }

    public Style deriveStyle(int thickness, boolean filled, Color color) {
        return new Builder(this).setThickness(thickness).setFilled(filled).setColor(color).build();
    }

    public Style deriveFillStyle(Color color) {
        return new Builder(this).setThickness(0).setFilled(true).setColor(color).build();
    }

    public Style deriveFillStyle(ColorKey colorKey) {
        return new Builder(this).setThickness(0).setFilled(true).setColor(colorKey).build();
    }

    private static final class Builder {
        private int thickness = 4;
        private boolean filled = false;
        private ColorKey colorKey = ColorKey.MAIN;
        private Color color;
        private int fontSize = 24;
        private float[] dash = null;
        private boolean mattersForSize = false;
        private int endCap = 2;
        private int fontStyle = 0;

        private Builder() {
        }

        private Builder(Style style) {
            this.thickness = style.thickness;
            this.filled = style.filled;
            this.colorKey = style.colorKey;
            this.color = style.color;
            this.fontSize = style.fontSize;
            this.dash = style.getDash();
            this.mattersForSize = style.mattersForSize;
            this.endCap = style.stroke.getEndCap();
        }

        private Builder setThickness(int thickness) {
            this.thickness = thickness;
            return this;
        }

        private Builder setFilled(boolean filled) {
            this.filled = filled;
            return this;
        }

        private Builder setColor(ColorKey key) {
            this.colorKey = key;
            this.color = null;
            return this;
        }

        private Builder setColor(Color color) {
            this.colorKey = null;
            this.color = color;
            return this;
        }

        private Builder setFontSize(int fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        private Builder setFontStyle(int fontStyle) {
            this.fontStyle = fontStyle;
            return this;
        }

        private Builder setDash(float[] dash) {
            this.dash = dash;
            return this;
        }

        private Builder setMattersForSize(boolean mattersForSize) {
            this.mattersForSize = mattersForSize;
            return this;
        }

        private Builder setEndCap(int endCap) {
            this.endCap = endCap;
            return this;
        }

        private Style build() {
            return new Style(this);
        }

        static /* synthetic */ Builder access$400(Builder x0, int x1) {
            return x0.setFontStyle(x1);
        }

        static /* synthetic */ Builder access$800(Builder x0, int x1) {
            return x0.setEndCap(x1);
        }

        static /* synthetic */ Builder access$900(Builder x0, float[] x1) {
            return x0.setDash(x1);
        }
    }
}

