/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

public class SVGTokenizer {
    private final String code;
    private int lastTokenPos;
    private int pos;
    private StringBuilder command;
    private float value;
    private char character;

    public SVGTokenizer(String code) {
        this.code = code;
        this.command = new StringBuilder();
        this.pos = 0;
    }

    private Token next() throws TokenizerException {
        this.lastTokenPos = this.pos;
        while (this.pos < this.code.length() && (Character.isWhitespace(this.code.charAt(this.pos)) || this.code.charAt(this.pos) == ',')) {
            ++this.pos;
        }
        if (this.pos == this.code.length()) {
            return Token.EOF;
        }
        this.character = this.code.charAt(this.pos);
        if (Character.isAlphabetic(this.character)) {
            this.command.setLength(0);
            ++this.pos;
            this.command.append(this.character);
            while (this.pos < this.code.length() && Character.isAlphabetic(this.code.charAt(this.pos))) {
                this.command.append(this.code.charAt(this.pos));
                ++this.pos;
            }
            return Token.COMMAND;
        }
        if (Character.isDigit(this.character) || this.character == '-' || this.character == '+') {
            this.value = this.parseNumber();
            return Token.NUMBER;
        }
        ++this.pos;
        return Token.CHAR;
    }

    private char peekChar() {
        return this.code.charAt(this.pos);
    }

    private float parseNumber() throws TokenizerException {
        int p0 = this.pos;
        if (this.peekChar() == '+' || this.peekChar() == '-') {
            ++this.pos;
        }
        while (this.pos < this.code.length() && (Character.isDigit(this.peekChar()) || this.peekChar() == '.')) {
            ++this.pos;
        }
        if (this.pos < this.code.length() && (this.peekChar() == 'e' || this.peekChar() == 'E')) {
            ++this.pos;
            if (this.peekChar() == '+' || this.peekChar() == '-' || Character.isDigit(this.peekChar())) {
                ++this.pos;
                while (this.pos < this.code.length() && (Character.isDigit(this.peekChar()) || this.peekChar() == '.')) {
                    ++this.pos;
                }
            } else {
                --this.pos;
            }
        }
        try {
            return Float.parseFloat(this.code.substring(p0, this.pos));
        }
        catch (NumberFormatException e) {
            throw new TokenizerException("not a number " + this.code.substring(p0, this.pos));
        }
    }

    private void unreadToken() {
        this.pos = this.lastTokenPos;
    }

    public void expect(char c) throws TokenizerException {
        if (this.next() != Token.CHAR) {
            throw new TokenizerException("expected character " + c);
        }
        if (this.character != c) {
            throw new RuntimeException("expected " + c + " found " + this.character);
        }
    }

    public float readFloat() throws TokenizerException {
        if (this.next() != Token.NUMBER) {
            throw new TokenizerException("expected a number");
        }
        return this.value;
    }

    public String readCommand() throws TokenizerException {
        if (this.next() != Token.COMMAND) {
            throw new TokenizerException("expected a command");
        }
        return this.command.toString();
    }

    public boolean nextIsNumber() throws TokenizerException {
        if (this.next() == Token.NUMBER) {
            this.unreadToken();
            return true;
        }
        this.unreadToken();
        return false;
    }

    public boolean nextIsChar(char c) throws TokenizerException {
        if (this.next() == Token.CHAR) {
            if (this.character == c) {
                return true;
            }
            this.unreadToken();
            return false;
        }
        this.unreadToken();
        return false;
    }

    public boolean isEOF() throws TokenizerException {
        if (this.next() == Token.EOF) {
            return true;
        }
        this.unreadToken();
        return false;
    }

    public String toString() {
        return this.code + " (" + this.pos + ")";
    }

    public String remaining() {
        String s = this.code.substring(this.pos).trim();
        this.pos = this.code.length();
        return s;
    }

    public String readTo(char c) {
        int p = this.pos;
        int brace = 0;
        while (this.pos < this.code.length() && (this.code.charAt(this.pos) != c || brace != 0)) {
            switch (this.code.charAt(this.pos)) {
                case '(': {
                    ++brace;
                    break;
                }
                case ')': {
                    --brace;
                }
            }
            ++this.pos;
        }
        String r = this.code.substring(p, this.pos).trim();
        while (this.pos < this.code.length() && this.code.charAt(this.pos) == c) {
            ++this.pos;
        }
        return r;
    }

    public static final class TokenizerException
    extends Exception {
        private TokenizerException(String message) {
            super(message);
        }
    }

    public static enum Token {
        EOF,
        COMMAND,
        NUMBER,
        CHAR;

    }
}

