/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.SVGTokenizer;
import de.neemann.digital.draw.graphics.Transform;
import de.neemann.digital.draw.graphics.TransformMatrix;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.graphics.VectorInterface;

public class PolygonParser {
    private final SVGTokenizer t;
    private float x;
    private float y;
    private VectorFloat polyStart;
    private VectorInterface lastQuadraticControlPoint;
    private VectorInterface lastCubicControlPoint;
    private String command = "";

    public PolygonParser(String path) {
        this.t = new SVGTokenizer(path);
    }

    private float nextValue() throws SVGTokenizer.TokenizerException {
        return this.t.readFloat();
    }

    private VectorFloat nextVector() throws SVGTokenizer.TokenizerException {
        this.x = this.nextValue();
        this.y = this.nextValue();
        return new VectorFloat(this.x, this.y);
    }

    private VectorFloat nextVectorInc() throws SVGTokenizer.TokenizerException {
        this.x += this.nextValue();
        this.y += this.nextValue();
        return new VectorFloat(this.x, this.y);
    }

    private VectorFloat nextVectorRel() throws SVGTokenizer.TokenizerException {
        return new VectorFloat(this.x + this.nextValue(), this.y + this.nextValue());
    }

    public Polygon create() throws ParserException {
        try {
            Polygon p = new Polygon(false);
            boolean closedPending = false;
            block45: while (!this.t.isEOF()) {
                if (this.t.nextIsNumber()) {
                    if (this.command.equals("m")) {
                        this.command = "l";
                    } else if (this.command.equals("M")) {
                        this.command = "L";
                    }
                } else {
                    this.command = this.t.readCommand();
                }
                switch (this.command) {
                    case "M": {
                        if (closedPending) {
                            closedPending = false;
                            p.addClosePath();
                        }
                        p.addMoveTo(this.setPolyStart(this.nextVector()));
                        this.clearControl();
                        continue block45;
                    }
                    case "m": {
                        if (closedPending) {
                            closedPending = false;
                            p.addClosePath();
                        }
                        p.addMoveTo(this.setPolyStart(this.nextVectorInc()));
                        this.clearControl();
                        continue block45;
                    }
                    case "V": {
                        this.y = this.nextValue();
                        p.add(this.getCurrent());
                        this.clearControl();
                        continue block45;
                    }
                    case "v": {
                        this.y += this.nextValue();
                        p.add(this.getCurrent());
                        this.clearControl();
                        continue block45;
                    }
                    case "H": {
                        this.x = this.nextValue();
                        p.add(this.getCurrent());
                        this.clearControl();
                        continue block45;
                    }
                    case "h": {
                        this.x += this.nextValue();
                        p.add(this.getCurrent());
                        this.clearControl();
                        continue block45;
                    }
                    case "l": {
                        p.add(this.nextVectorInc());
                        this.clearControl();
                        continue block45;
                    }
                    case "L": {
                        p.add(this.nextVector());
                        this.clearControl();
                        continue block45;
                    }
                    case "c": {
                        p.add(this.nextVectorRel(), this.setLastC3(this.nextVectorRel()), this.nextVectorInc());
                        continue block45;
                    }
                    case "C": {
                        p.add(this.nextVector(), this.setLastC3(this.nextVector()), this.nextVector());
                        continue block45;
                    }
                    case "q": {
                        p.add(this.setLastC2(this.nextVectorRel()), this.nextVectorInc());
                        continue block45;
                    }
                    case "Q": {
                        p.add(this.setLastC2(this.nextVector()), this.nextVector());
                        continue block45;
                    }
                    case "s": {
                        this.addCubicWithReflect(p, this.getCurrent(), this.nextVectorRel(), this.nextVectorInc());
                        continue block45;
                    }
                    case "S": {
                        this.addCubicWithReflect(p, this.getCurrent(), this.nextVector(), this.nextVector());
                        continue block45;
                    }
                    case "t": {
                        this.addQuadraticWithReflect(p, this.getCurrent(), this.nextVectorInc());
                        continue block45;
                    }
                    case "T": {
                        this.addQuadraticWithReflect(p, this.getCurrent(), this.nextVector());
                        continue block45;
                    }
                    case "a": {
                        this.addArc(p, this.getCurrent(), this.nextValue(), this.nextValue(), this.nextValue(), this.nextValue() != 0.0f, this.nextValue() != 0.0f, this.nextVectorInc());
                        this.clearControl();
                        continue block45;
                    }
                    case "A": {
                        this.addArc(p, this.getCurrent(), this.nextValue(), this.nextValue(), this.nextValue(), this.nextValue() != 0.0f, this.nextValue() != 0.0f, this.nextVector());
                        this.clearControl();
                        continue block45;
                    }
                    case "Z": 
                    case "z": {
                        closedPending = true;
                        if (this.polyStart != null) {
                            this.x = this.polyStart.getXFloat();
                            this.y = this.polyStart.getYFloat();
                        }
                        this.clearControl();
                        continue block45;
                    }
                }
                throw new ParserException("unsupported path command " + this.command);
            }
            if (closedPending) {
                p.setClosed(true);
            }
            return p;
        }
        catch (SVGTokenizer.TokenizerException e) {
            throw new ParserException("error parsing a path", e);
        }
    }

    private VectorFloat setPolyStart(VectorFloat v) {
        this.polyStart = v;
        return v;
    }

    private VectorInterface getCurrent() {
        return new VectorFloat(this.x, this.y);
    }

    private VectorInterface setLastC2(VectorInterface p) {
        this.lastQuadraticControlPoint = p;
        this.lastCubicControlPoint = null;
        return p;
    }

    private VectorInterface setLastC3(VectorInterface p) {
        this.lastCubicControlPoint = p;
        this.lastQuadraticControlPoint = null;
        return p;
    }

    private void clearControl() {
        this.lastQuadraticControlPoint = null;
        this.lastCubicControlPoint = null;
    }

    private VectorInterface getLastC2() {
        if (this.lastQuadraticControlPoint == null) {
            return this.getCurrent();
        }
        return this.lastQuadraticControlPoint;
    }

    private VectorInterface getLastC3() {
        if (this.lastCubicControlPoint == null) {
            return this.getCurrent();
        }
        return this.lastCubicControlPoint;
    }

    private void addArc(Polygon p, VectorInterface current, float rx, float ry, float rot, boolean large, boolean sweep, VectorFloat pos) {
        if (rx == 0.0f || ry == 0.0f) {
            p.add(pos);
            return;
        }
        if (rx < 0.0f) {
            rx = -rx;
        }
        if (ry < 0.0f) {
            ry = -ry;
        }
        Transform tr = Transform.IDENTITY;
        if (rx != ry) {
            tr = TransformMatrix.scale(1.0f, rx / ry);
        }
        if (rot != 0.0f) {
            tr = Transform.mul(TransformMatrix.rotate(-rot), tr);
        }
        Transform invert = tr.invert();
        VectorInterface p1 = current.transform(tr);
        VectorInterface p2 = pos.transform(tr);
        float r = rx;
        float dist = p1.sub(p2).len();
        if (dist > r * 2.0f) {
            r = dist / 2.0f;
        }
        double x1 = p1.getXFloat();
        double y1 = p1.getYFloat();
        double x2 = p2.getXFloat();
        double y2 = p2.getYFloat();
        double x1q = x1 * x1;
        double y1q = y1 * y1;
        double x2q = x2 * x2;
        double y2q = y2 * y2;
        double rq = r * r;
        try {
            int n;
            double x0A = ((double)r * (y1 - y2) * PolygonParser.sqrt(rq * (4.0 * rq - y1q + y2 * (2.0 * y1 - y2)) - rq * (x1q - 2.0 * x1 * x2 + x2q)) * PolygonParser.sign(x1 - x2) + (double)r * (x1 + x2) * PolygonParser.sqrt(rq * (y1q - 2.0 * y1 * y2 + y2q) + rq * (x1q - 2.0 * x1 * x2 + x2q))) / ((double)(2.0f * r) * PolygonParser.sqrt(rq * (y1q - 2.0 * y1 * y2 + y2q) + rq * (x1q - 2.0 * x1 * x2 + x2q)));
            double y0A = ((double)r * (y1 + y2) * PolygonParser.sqrt(rq * (y1q - 2.0 * y1 * y2 + y2q) + rq * (x1q - 2.0 * x1 * x2 + x2q)) - (double)r * PolygonParser.sqrt(rq * (4.0 * rq - y1q + y2 * (2.0 * y1 - y2)) - rq * (x1q - 2.0 * x1 * x2 + x2q)) * PolygonParser.abs(x1 - x2)) / ((double)(2.0f * r) * PolygonParser.sqrt(rq * (y1q - 2.0 * y1 * y2 + y2q) + rq * (x1q - 2.0 * x1 * x2 + x2q)));
            double x0B = ((double)r * (x1 + x2) * PolygonParser.sqrt(rq * (y1q - 2.0 * y1 * y2 + y2q) + rq * (x1q - 2.0 * x1 * x2 + x2q)) - (double)r * (y1 - y2) * PolygonParser.sqrt(rq * (4.0 * rq - y1q + y2 * (2.0 * y1 - y2)) - rq * (x1q - 2.0 * x1 * x2 + x2q)) * PolygonParser.sign(x1 - x2)) / ((double)(2.0f * r) * PolygonParser.sqrt(rq * (y1q - 2.0 * y1 * y2 + y2q) + rq * (x1q - 2.0 * x1 * x2 + x2q)));
            double y0B = ((double)r * PolygonParser.sqrt(rq * (4.0 * rq - y1q + y2 * (2.0 * y1 - y2)) - rq * (x1q - 2.0 * x1 * x2 + x2q)) * PolygonParser.abs(x1 - x2) + (double)r * (y1 + y2) * PolygonParser.sqrt(rq * (y1q - 2.0 * y1 * y2 + y2q) + rq * (x1q - 2.0 * x1 * x2 + x2q))) / ((double)(2.0f * r) * PolygonParser.sqrt(rq * (y1q - 2.0 * y1 * y2 + y2q) + rq * (x1q - 2.0 * x1 * x2 + x2q)));
            double startA = Math.atan2(y1 - y0A, x1 - x0A);
            double endA = Math.atan2(y2 - y0A, x2 - x0A);
            double startB = Math.atan2(y1 - y0B, x1 - x0B);
            double endB = Math.atan2(y2 - y0B, x2 - x0B);
            if (sweep) {
                if (endA < startA) {
                    endA += Math.PI * 2;
                }
                if (endB < startB) {
                    endB += Math.PI * 2;
                }
            } else {
                if (endA > startA) {
                    endA -= Math.PI * 2;
                }
                if (endB > startB) {
                    endB -= Math.PI * 2;
                }
            }
            double sizeA = Math.abs(startA - endA);
            double sizeB = Math.abs(startB - endB);
            double start = startA;
            double end = endA;
            double x0 = x0A;
            double y0 = y0A;
            if (large ^ sizeA > sizeB) {
                start = startB;
                end = endB;
                x0 = x0B;
                y0 = y0B;
            }
            if ((n = (int)Math.round(Math.abs(start - end) / 0.5235987755982988)) < 1) {
                n = 1;
            }
            double delta = Math.abs(start - end) / (double)n;
            if (!sweep) {
                delta = -delta;
            }
            double lastStart = start;
            start += delta;
            for (int i = 1; i < n; ++i) {
                this.addArcPoint(p, lastStart, start, x0, y0, r, invert);
                lastStart = start;
                start += delta;
            }
            this.addArcPoint(p, lastStart, end, x0, y0, r, invert);
        }
        catch (SqrtException e) {
            p.add(pos);
        }
    }

    private void addArcPoint(Polygon p, double alpha0, double alpha1, double x0, double y0, float r, Transform tr) {
        double mean = (alpha0 + alpha1) / 2.0;
        double rLong = (double)r / Math.cos(Math.abs(alpha0 - alpha1) / 2.0);
        VectorFloat c = new VectorFloat((float)(x0 + rLong * Math.cos(mean)), (float)(y0 + rLong * Math.sin(mean)));
        VectorFloat p1 = new VectorFloat((float)(x0 + (double)r * Math.cos(alpha1)), (float)(y0 + (double)r * Math.sin(alpha1)));
        p.add(c.transform(tr), p1.transform(tr));
    }

    private static double sqrt(double x) throws SqrtException {
        if (x > 0.0) {
            return Math.sqrt(x);
        }
        if (x > -1.0E-6) {
            return 0.0;
        }
        throw new SqrtException();
    }

    private static double sign(double x) {
        return Math.signum(x);
    }

    private static double abs(double x) {
        return Math.abs(x);
    }

    private void addQuadraticWithReflect(Polygon poly, VectorInterface start, VectorInterface p) {
        VectorInterface c = start.add(start.sub(this.getLastC2()));
        poly.add(this.setLastC2(c), p);
    }

    private void addCubicWithReflect(Polygon poly, VectorInterface start, VectorInterface c2, VectorInterface p) {
        VectorInterface c1 = start.add(start.sub(this.getLastC3()));
        poly.add(c1, this.setLastC3(c2), p);
    }

    public Polygon parsePolygon() throws ParserException {
        try {
            return this.parsePolygonPolyline(true);
        }
        catch (SVGTokenizer.TokenizerException e) {
            throw new ParserException("error parsing a polygon", e);
        }
    }

    public Polygon parsePolyline() throws ParserException {
        try {
            return this.parsePolygonPolyline(false);
        }
        catch (SVGTokenizer.TokenizerException e) {
            throw new ParserException("error parsing a polyline", e);
        }
    }

    private Polygon parsePolygonPolyline(boolean closed) throws SVGTokenizer.TokenizerException {
        Polygon p = new Polygon(closed);
        while (!this.t.isEOF()) {
            p.add(new VectorFloat(this.nextValue(), this.nextValue()));
        }
        return p;
    }

    private static class SqrtException
    extends Exception {
        private SqrtException() {
        }
    }

    public static final class ParserException
    extends Exception {
        private ParserException(String message) {
            super(message);
        }

        private ParserException(String message, Exception cause) {
            super(message, cause);
        }
    }
}

