/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.GraphicSwing;
import de.neemann.digital.draw.graphics.VectorInterface;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public final class GraphicsImage
extends GraphicSwing
implements Closeable {
    private final OutputStream out;
    private final String format;
    private final float scale;
    private BufferedImage bi;

    public GraphicsImage(OutputStream out, String format, float scale) {
        super(null);
        this.out = out;
        this.format = format;
        this.scale = scale;
    }

    @Override
    public Graphic setBoundingBox(VectorInterface min, VectorInterface max) {
        int thickness = 4;
        this.bi = new BufferedImage(Math.round((max.getXFloat() - min.getXFloat() + (float)(thickness * 2)) * this.scale), Math.round((max.getYFloat() - min.getYFloat() + (float)(thickness * 2)) * this.scale), 2);
        Graphics2D gr = this.bi.createGraphics();
        gr.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gr.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        gr.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        gr.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        gr.setColor(new Color(255, 255, 255, 0));
        gr.fillRect(0, 0, this.bi.getWidth(), this.bi.getHeight());
        gr.scale(this.scale, this.scale);
        gr.translate((float)thickness - min.getXFloat(), (float)thickness - min.getYFloat());
        this.setGraphics2D(gr);
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            if (this.bi != null) {
                ImageIO.write((RenderedImage)this.bi, this.format, this.out);
            }
            this.out.close();
        }
    }

    public BufferedImage getBufferedImage() {
        return this.bi;
    }
}

