/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.draw.graphics.ColorStyleHighContrast;
import de.neemann.digital.draw.graphics.ColorStyleMonochrome;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.GraphicSwing;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.SVGSettings;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.TextFormatLaTeX;
import de.neemann.digital.draw.graphics.TextFormatSVG;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.graphics.VectorInterface;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashSet;

public class GraphicSVG
extends Graphic {
    private static final int DEF_SCALE = 15;
    private final OutputStream out;
    private final File source;
    private final int svgScale;
    private final HashSet<Graphic.Flag> flags = new HashSet();
    private BufferedWriter w;
    private TextStyle textStyle = new TextFormatSVG();
    private ColorStyle colorStyle = Style::getColor;

    public GraphicSVG(OutputStream out) {
        this(out, SVGSettings.getInstance().getAttributes());
    }

    public GraphicSVG(OutputStream out, ElementAttributes a) {
        this(out, null, 15);
        if (a.get(SVGSettings.LATEX).booleanValue()) {
            this.setTextStyle(new TextFormatLaTeX(a.get(SVGSettings.PINS_IN_MATH_MODE)));
        }
        if (a.get(SVGSettings.HIGH_CONTRAST).booleanValue()) {
            this.setColorStyle(new ColorStyleHighContrast());
        }
        if (a.get(SVGSettings.SMALL_IO).booleanValue()) {
            this.setFlag(Graphic.Flag.smallIO);
        }
        if (a.get(SVGSettings.HIDE_TEST).booleanValue()) {
            this.setFlag(Graphic.Flag.hideTest);
        }
        if (a.get(SVGSettings.NO_SHAPE_FILLING).booleanValue()) {
            this.setFlag(Graphic.Flag.noShapeFilling);
        }
        if (a.get(SVGSettings.NO_PIN_MARKER).booleanValue()) {
            this.setFlag(Graphic.Flag.noPinMarker);
        }
        if (a.get(SVGSettings.THINNER_LINES).booleanValue()) {
            this.setFlag(Graphic.Flag.thinnerLines);
        }
        if (a.get(SVGSettings.MONOCHROME).booleanValue()) {
            this.setColorStyle(new ColorStyleMonochrome(this.colorStyle));
        }
    }

    public GraphicSVG(File file, File source, int svgScale) throws IOException {
        this(new FileOutputStream(file), source, svgScale);
    }

    public GraphicSVG(OutputStream out, File source, int svgScale) {
        this.out = out;
        this.source = source;
        this.svgScale = svgScale;
    }

    @Override
    public Graphic setBoundingBox(VectorInterface min, VectorInterface max) {
        try {
            this.w = new BufferedWriter(new OutputStreamWriter(this.out, StandardCharsets.UTF_8));
            this.w.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!-- Created with Digital by H.Neemann -->\n");
            this.w.write("<!-- created: " + new Date() + " -->\n");
            if (this.source != null) {
                this.w.write("<!-- source: " + this.source.getPath() + " -->\n");
            }
            this.w.write("\n<svg\n   xmlns:svg=\"http://www.w3.org/2000/svg\"\n   xmlns=\"http://www.w3.org/2000/svg\"\n");
            double width = (double)((max.getXFloat() - min.getXFloat() + 4.0f) * (float)this.svgScale) / 100.0;
            double height = (double)((max.getYFloat() - min.getYFloat() + 4.0f) * (float)this.svgScale) / 100.0;
            int lineCorr = 2;
            this.w.write("   width=\"" + width + "mm\"\n   height=\"" + height + "mm\"\n   viewBox=\"" + (min.getX() - 2) + " " + (min.getY() - 2) + " " + (max.getX() - min.getX() + 4) + " " + (max.getY() - min.getY() + 4) + "\">\n");
            this.w.write("<g stroke-linecap=\"square\">\n");
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.w != null) {
            this.w.write("</g>\n");
            this.w.write("</svg>");
            this.w.close();
        }
    }

    @Override
    public void drawLine(VectorInterface p1, VectorInterface p2, Style style) {
        try {
            this.w.write("<line x1=\"" + p1.getXFloat() + "\" y1=\"" + p1.getYFloat() + "\" x2=\"" + p2.getXFloat() + "\" y2=\"" + p2.getYFloat() + "\" stroke=\"" + this.getColor(style) + "\" stroke-linecap=\"square\" stroke-width=\"" + this.getStrokeWidth(style) + "\"");
            GraphicSVG.addStrokeDash(this.w, style.getDash());
            this.w.write(" />\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void drawPolygon(Polygon p, Style style) {
        try {
            this.w.write("<path d=\"" + p + "\"");
            GraphicSVG.addStrokeDash(this.w, style.getDash());
            if (p.getEvenOdd() && style.isFilled()) {
                this.w.write(" fill-rule=\"evenodd\"");
            }
            if (style.isFilled() && p.isClosed() && !this.isFlagSet(Graphic.Flag.noShapeFilling)) {
                this.w.write(" stroke=\"" + this.getColor(style) + "\" stroke-width=\"" + this.getStrokeWidth(style) + "\" fill=\"" + this.getColor(style) + "\" fill-opacity=\"" + this.getOpacity(style) + "\"/>\n");
            } else {
                double strokeWidth = this.getStrokeWidth(style);
                if (strokeWidth == 0.0) {
                    strokeWidth = this.getStrokeWidth(Style.THIN);
                }
                this.w.write(" stroke=\"" + this.getColor(style) + "\" stroke-width=\"" + strokeWidth + "\" fill=\"none\"/>\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private double getStrokeWidth(Style style) {
        if (this.isFlagSet(Graphic.Flag.thinnerLines)) {
            return (double)style.getThickness() * 0.7;
        }
        return style.getThickness();
    }

    @Override
    public void drawCircle(VectorInterface p1, VectorInterface p2, Style style) {
        try {
            VectorInterface c = p1.add(p2).div(2);
            double r = (double)Math.abs(p2.sub(p1).getXFloat()) / 2.0;
            if (style.isFilled()) {
                this.w.write("<circle cx=\"" + c.getXFloat() + "\" cy=\"" + c.getYFloat() + "\" r=\"" + r + "\" stroke=\"" + this.getColor(style) + "\" stroke-width=\"" + this.getStrokeWidth(style) + "\" fill=\"" + this.getColor(style) + "\" />\n");
            } else {
                this.w.write("<circle cx=\"" + c.getXFloat() + "\" cy=\"" + c.getYFloat() + "\" r=\"" + r + "\" stroke=\"" + this.getColor(style) + "\" stroke-width=\"" + this.getStrokeWidth(style) + "\" fill=\"none\"");
                GraphicSVG.addStrokeDash(this.w, style.getDash());
                this.w.write(" />\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void drawText(VectorInterface p1, VectorInterface p2, VectorInterface p3, String text, Orientation orientation, Style style) {
        if (text == null || text.length() == 0) {
            return;
        }
        try {
            text = this.textStyle.format(text, style);
            boolean rotateText = false;
            if (p1.getY() == p2.getY()) {
                if (p1.getX() > p2.getX()) {
                    orientation = orientation.rot(2);
                }
            } else {
                orientation = p1.getY() < p2.getY() ? orientation.rot(2) : orientation.rot(0);
                rotateText = true;
            }
            VectorFloat p = new VectorFloat(p1);
            int oy = GraphicSwing.getMirrorYOrientation(orientation, p1, p2, p3);
            switch (oy) {
                case 1: {
                    p = p.add(new VectorFloat(0.0f, (float)style.getFontSize() / 2.0f - (float)style.getFontSize() / 8.0f));
                    break;
                }
                case 2: {
                    p = p.add(new VectorFloat(0.0f, (float)(style.getFontSize() * 3) / 4.0f));
                    break;
                }
            }
            if (rotateText) {
                this.w.write("<text text-anchor=\"" + this.getAchor(orientation.getX()) + "\" x=\"" + p.getXFloat() + "\" y=\"" + p.getYFloat() + "\" fill=\"" + this.getColor(style) + "\" style=\"font-size:" + style.getFontSize() + "px\" transform=\"rotate(-90," + this.str(p1) + ")\" >" + text + "</text>\n");
            } else {
                this.w.write("<text text-anchor=\"" + this.getAchor(orientation.getX()) + "\" x=\"" + p.getXFloat() + "\" y=\"" + p.getYFloat() + "\" fill=\"" + this.getColor(style) + "\" style=\"font-size:" + style.getFontSize() + "px\">" + text + "</text>\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getColor(Style style) {
        return "#" + Integer.toHexString(this.colorStyle.getColor(style).getRGB()).substring(2);
    }

    private String getOpacity(Style style) {
        double op = (double)style.getColor().getAlpha() / 255.0;
        return Double.toString(op);
    }

    public static String escapeXML(String text) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private String getAchor(int x) {
        switch (x) {
            case 1: {
                return "middle";
            }
            case 2: {
                return "end";
            }
        }
        return "start";
    }

    @Override
    public void openGroup() {
        try {
            this.w.write("<g>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void closeGroup() {
        try {
            this.w.write("</g>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addStrokeDash(Writer w, float[] dashArray) throws IOException {
        if (dashArray != null) {
            w.write(" stroke-dasharray=\"");
            for (int i = 0; i < dashArray.length; ++i) {
                if (i != 0) {
                    w.write(44);
                }
                w.write(Float.toString(dashArray[i]));
            }
            w.write(34);
        }
    }

    private String str(VectorInterface p) {
        return p.getXFloat() + "," + p.getYFloat();
    }

    private void setTextStyle(TextStyle textStyle) {
        this.textStyle = textStyle;
    }

    private void setColorStyle(ColorStyle colorStyle) {
        this.colorStyle = colorStyle;
    }

    private void setFlag(Graphic.Flag flag) {
        this.flags.add(flag);
    }

    @Override
    public boolean isFlagSet(Graphic.Flag flag) {
        return this.flags.contains((Object)flag);
    }

    public static interface ColorStyle {
        public Color getColor(Style var1);
    }

    public static interface TextStyle {
        public String format(String var1, Style var2);
    }
}

