/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.GraphicSwing;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Polygon;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.graphics.VectorInterface;
import de.neemann.digital.draw.graphics.text.formatter.GraphicsFormatter;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;

public class GraphicMinMax
extends Graphic {
    private final boolean includeText;
    private final Graphic parent;
    private Vector min;
    private Vector max;

    public GraphicMinMax() {
        this(true, null);
    }

    public GraphicMinMax(Graphic parent) {
        this(true, parent);
    }

    public GraphicMinMax(boolean includeText, Graphic parent) {
        this.includeText = includeText;
        this.parent = parent;
    }

    @Override
    public void drawLine(VectorInterface p1, VectorInterface p2, Style style) {
        this.check(p1);
        this.check(p2);
    }

    @Override
    public void drawPolygon(Polygon p, Style style) {
        p.traverse(this::check);
    }

    @Override
    public void drawCircle(VectorInterface p1, VectorInterface p2, Style style) {
        this.check(p1);
        this.check(p2);
    }

    public void check(VectorInterface p) {
        if (this.min == null || this.max == null) {
            this.min = new Vector(p.getX(), p.getY());
            this.max = new Vector(p.getX(), p.getY());
        } else {
            this.min = Vector.min(this.min, p);
            this.max = Vector.max(this.max, p);
        }
    }

    @Override
    public void drawText(VectorInterface p1, VectorInterface p2, VectorInterface p3, String text, Orientation orientation, Style style) {
        if (this.includeText || style.mattersAlwaysForSize()) {
            GraphicMinMax.approxTextSize(this, p1, p2, p3, text, orientation, style);
        }
    }

    public static void approxTextSize(Graphic gr, VectorInterface p1, VectorInterface p2, VectorInterface p3, String text, Orientation orientation, Style style) {
        if (text != null && text.length() > 0) {
            int oy;
            VectorFloat delta = p2.sub(p1).norm();
            VectorFloat height = new VectorFloat(delta.getYFloat(), -delta.getXFloat()).mul(style.getFontSize());
            int textWidth = GraphicMinMax.getTextWidth(text, style);
            VectorFloat width = delta.mul(textWidth);
            VectorInterface p = p1;
            if (orientation.getX() != 0) {
                p = p.sub(width.mul(orientation.getX()).div(2));
            }
            p = (oy = GraphicSwing.getMirrorYOrientation(orientation, p1, p2, p3)) != 0 ? p.sub(height.mul(oy).div(2)) : p.sub(height.div(4));
            gr.drawPolygon(new Polygon(true).add(p).add(p.add(width)).add(p.add(width).add(height)).add(p.add(height)), Style.THIN);
        }
    }

    public static int getTextWidth(String text, Style style) {
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
        GraphicsFormatter.Fragment f = GraphicsFormatter.createFragment((fragment, font, str) -> {
            Rectangle2D rec = style.getFont().getStringBounds(str, fontRenderContext);
            fragment.set((int)rec.getWidth(), (int)rec.getHeight(), 0);
        }, style.getFont(), text);
        return f.getWidth();
    }

    public Vector getMin() {
        return this.min;
    }

    public Vector getMax() {
        return this.max;
    }

    @Override
    public boolean isFlagSet(Graphic.Flag flag) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.isFlagSet(flag);
    }

    public boolean isValid() {
        return this.min != null && this.max != null;
    }

    public String toString() {
        return "GraphicMinMax{min=" + this.min + ", max=" + this.max + '}';
    }
}

