/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.graphics;

import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.graphics.ExportFactory;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.GraphicMinMax;
import de.neemann.digital.draw.graphics.linemerger.GraphicLineCollector;
import de.neemann.digital.draw.graphics.linemerger.GraphicSkipLines;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Export {
    private final Circuit circuit;
    private final ExportFactory factory;
    private final boolean hideTests;

    public Export(Circuit circuit, ExportFactory factory) {
        this(circuit, factory, false);
    }

    public Export(Circuit circuit, ExportFactory factory, boolean hideTests) {
        this.circuit = circuit;
        this.factory = factory;
        this.hideTests = hideTests;
    }

    public void export(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.export(out);
        }
        catch (IOException e) {
            file.delete();
            throw new IOException(Lang.get("err_errorWritingFile_N", file), e);
        }
    }

    public void export(OutputStream out) throws IOException {
        block7: {
            try (Graphic gr = this.factory.create(out);){
                GraphicMinMax minMax = new GraphicMinMax(gr);
                this.circuit.drawTo(minMax, this.hideTests);
                if (minMax.isValid()) {
                    gr.setBoundingBox(minMax.getMin(), minMax.getMax());
                    GraphicLineCollector glc = new GraphicLineCollector();
                    this.circuit.drawTo(glc, this.hideTests);
                    glc.drawTo(gr);
                    this.circuit.drawTo(new GraphicSkipLines(gr), this.hideTests);
                    break block7;
                }
                throw new IOException(Lang.get("err_circuitContainsNoComponents", new Object[0]));
            }
        }
    }
}

