/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.elements;

import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.graphics.Vector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class WireMerger {
    private HashMap<Integer, WireContainer> wireContainers = new HashMap();
    private OrientationHandler handler;

    public WireMerger(Wire.Orientation orientation) {
        switch (orientation) {
            case horizontal: {
                this.handler = new OrientationHandlerHorizontal();
                break;
            }
            case vertical: {
                this.handler = new OrientationHandlerVertical();
                break;
            }
            default: {
                throw new RuntimeException("wrong line orientation");
            }
        }
    }

    public void add(Wire w) {
        SimpleWire sw = new SimpleWire(this.handler.getWireClass(w.p1), this.handler.getS(w.p1), this.handler.getS(w.p2));
        WireContainer wc = this.wireContainers.get(sw.wireClass);
        if (wc == null) {
            wc = new WireContainer(sw.wireClass);
            this.wireContainers.put(sw.wireClass, wc);
        }
        wc.add(sw);
    }

    public void addTo(ArrayList<Wire> wires) {
        for (WireContainer wc : this.wireContainers.values()) {
            wc.addTo(wires);
        }
    }

    public void protectPoints(Collection<Vector> points) {
        for (Vector v : points) {
            WireContainer wc = this.wireContainers.get(this.handler.getWireClass(v));
            if (wc == null) continue;
            wc.protect(this.handler.getS(v));
        }
    }

    private class WireContainer {
        private int wireClass;
        private ArrayList<SimpleWire> wires;

        WireContainer(int wireClass) {
            this.wireClass = wireClass;
            this.wires = new ArrayList();
        }

        public void add(SimpleWire newSimpleWire) {
            this.wires.add(newSimpleWire);
            this.simplify(newSimpleWire);
        }

        private void simplify(SimpleWire changedWire) {
            for (SimpleWire wire : this.wires) {
                if (wire.equals(changedWire) || !wire.tryMerge(changedWire)) continue;
                this.wires.remove(changedWire);
                this.simplify(wire);
                return;
            }
        }

        public void addTo(ArrayList<Wire> list) {
            for (SimpleWire sw : this.wires) {
                list.add(WireMerger.this.handler.toWire(sw));
            }
        }

        public void protect(int s) {
            int len = this.wires.size();
            for (int i = 0; i < len; ++i) {
                SimpleWire sw = this.wires.get(i);
                if (!sw.containsAsInner(s)) continue;
                int s2 = sw.s2;
                sw.s2 = s;
                this.wires.add(new SimpleWire(this.wireClass, s, s2));
            }
        }
    }

    static class OrientationHandlerVertical
    implements OrientationHandler {
        OrientationHandlerVertical() {
        }

        @Override
        public Wire toWire(SimpleWire wire) {
            return new Wire(new Vector(wire.wireClass, wire.s1), new Vector(wire.wireClass, wire.s2));
        }

        @Override
        public int getS(Vector v) {
            return v.y;
        }

        @Override
        public int getWireClass(Vector v) {
            return v.x;
        }
    }

    static class OrientationHandlerHorizontal
    implements OrientationHandler {
        OrientationHandlerHorizontal() {
        }

        @Override
        public Wire toWire(SimpleWire wire) {
            return new Wire(new Vector(wire.s1, wire.wireClass), new Vector(wire.s2, wire.wireClass));
        }

        @Override
        public int getWireClass(Vector v) {
            return v.y;
        }

        @Override
        public int getS(Vector v) {
            return v.x;
        }
    }

    static class SimpleWire {
        private int wireClass;
        private int s1;
        private int s2;

        SimpleWire(int wireClass, int s1, int s2) {
            this.wireClass = wireClass;
            if (s2 < s1) {
                this.s1 = s2;
                this.s2 = s1;
            } else {
                this.s1 = s1;
                this.s2 = s2;
            }
        }

        private boolean tryMerge(SimpleWire other) {
            if (this.s2 < other.s1 || other.s2 < this.s1) {
                return false;
            }
            this.s1 = Math.min(this.s1, other.s1);
            this.s2 = Math.max(this.s2, other.s2);
            return true;
        }

        private boolean containsAsInner(int s) {
            return this.s1 < s && this.s2 > s;
        }
    }

    static interface OrientationHandler {
        public Wire toWire(SimpleWire var1);

        public int getS(Vector var1);

        public int getWireClass(Vector var1);
    }
}

