/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.elements;

import de.neemann.digital.draw.elements.Wire;
import de.neemann.digital.draw.elements.WireMerger;
import de.neemann.digital.draw.graphics.Vector;
import java.util.ArrayList;
import java.util.HashSet;

public class WireConsistencyChecker {
    private ArrayList<Wire> wires;

    public WireConsistencyChecker(ArrayList<Wire> wires) {
        this.wires = wires;
    }

    public ArrayList<Wire> check() {
        this.wires = this.merge(this.wires);
        return this.wires;
    }

    private ArrayList<Wire> merge(ArrayList<Wire> wires) {
        HashSet<Vector> horiPoints = new HashSet<Vector>();
        HashSet<Vector> vertPoints = new HashSet<Vector>();
        HashSet<Vector> diagPoints = new HashSet<Vector>();
        ArrayList<Wire> newWires = new ArrayList<Wire>();
        WireMerger hori = new WireMerger(Wire.Orientation.horizontal);
        WireMerger vert = new WireMerger(Wire.Orientation.vertical);
        block4: for (Wire w : wires) {
            if (w.p1.equals(w.p2)) continue;
            switch (w.getOrientation()) {
                case horizontal: {
                    hori.add(w);
                    horiPoints.add(w.p1);
                    horiPoints.add(w.p2);
                    continue block4;
                }
                case vertical: {
                    vert.add(w);
                    vertPoints.add(w.p1);
                    vertPoints.add(w.p2);
                    continue block4;
                }
            }
            if (!this.contains(newWires, w)) {
                newWires.add(w);
            }
            diagPoints.add(w.p1);
            diagPoints.add(w.p2);
        }
        hori.protectPoints(diagPoints);
        hori.protectPoints(vertPoints);
        vert.protectPoints(diagPoints);
        vert.protectPoints(horiPoints);
        hori.addTo(newWires);
        vert.addTo(newWires);
        return newWires;
    }

    private boolean contains(ArrayList<Wire> list, Wire wire) {
        for (Wire w : list) {
            if (!w.equalsContent(wire)) continue;
            return true;
        }
        return false;
    }
}

