/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.elements;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.Value;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.elements.Movable;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.graphics.VectorFloat;
import de.neemann.digital.draw.shapes.Drawable;
import de.neemann.digital.draw.shapes.ObservableValueReader;
import de.neemann.digital.gui.Settings;
import java.util.Collection;

public class Wire
implements Drawable,
Movable,
ObservableValueReader {
    private static final int MIN_LABEL_WIRE_LEN = 80;
    private static final int MIN_CROSS_WIRE_LEN = 40;
    private static final int MIN_CROSS_WIRE_LEN_SPLITTER = 120;
    private static final int CROSS_LEN = 4;
    private static final int DISPLACE = 10;
    public Vector p1;
    public Vector p2;
    private transient ObservableValue observableValue;
    private transient Value value;
    private transient boolean p1Dot;
    private transient boolean p2Dot;
    private transient int bits;
    private transient boolean isConnectedToSplitter;

    public Wire(Vector p1, Vector p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    public Wire(Wire proto) {
        this.p1 = new Vector(proto.p1);
        this.p2 = new Vector(proto.p2);
        this.p1Dot = proto.p1Dot;
        this.p2Dot = proto.p2Dot;
    }

    @Override
    public void readObservableValues() {
        this.value = this.observableValue != null ? this.observableValue.getCopy() : null;
    }

    @Override
    public void drawTo(Graphic graphic, Style highLight) {
        int minCrossLen;
        Vector pos;
        Style style = highLight;
        if (style == null) {
            style = Style.getWireStyle(this.value);
        }
        graphic.drawLine(this.p1, this.p2, style);
        if (highLight == Style.ERROR && graphic.isFlagSet(Graphic.Flag.tiny)) {
            Vector min = Vector.min(this.p1, this.p2).add(-20, -20);
            Vector max = Vector.max(this.p1, this.p2).add(20, 20);
            graphic.drawCircleHighlight(min, max, highLight);
        }
        if (this.value != null) {
            this.bits = this.value.getBits();
        }
        boolean showBits = Settings.getInstance().get(Keys.SETTINGS_SHOW_WIRE_BITS);
        int wireLen = Math.abs(this.p1.x - this.p2.x);
        if (this.value != null && this.p1.y == this.p2.y && wireLen > 80 && this.value.getBits() > 1) {
            de.neemann.digital.draw.graphics.Orientation ori;
            pos = this.getRoundPos();
            if (showBits) {
                pos = pos.add(0, 3);
                ori = de.neemann.digital.draw.graphics.Orientation.RIGHTTOP;
            } else {
                pos = pos.add(0, -3);
                ori = de.neemann.digital.draw.graphics.Orientation.CENTERBOTTOM;
            }
            graphic.drawText(pos, this.value.toString(), ori, Style.WIRE_VALUE);
        }
        int n = minCrossLen = this.isConnectedToSplitter ? 120 : 40;
        if (this.bits > 1 && this.p1.y == this.p2.y && wireLen >= minCrossLen && showBits) {
            pos = this.getRoundPos();
            graphic.drawLine(pos.add(4, 4), pos.add(-4, -4), Style.WIRE_BITS);
            Vector numPos = pos.add(0, -3);
            graphic.drawText(numPos, Integer.toString(this.bits), de.neemann.digital.draw.graphics.Orientation.LEFTBOTTOM, Style.WIRE_BITS);
        }
        if (this.p1Dot || this.p2Dot) {
            Vector r = new Vector(style.getThickness(), style.getThickness());
            if (this.p1Dot) {
                graphic.drawCircle(this.p1.sub(r), this.p1.add(r), style);
            }
            if (this.p2Dot) {
                graphic.drawCircle(this.p2.sub(r), this.p2.add(r), style);
            }
        }
    }

    private Vector getRoundPos() {
        Vector pos = this.p1.add(this.p2).div(2);
        return new Vector((pos.x + 10) / 20 * 20 - 10, pos.y);
    }

    @Override
    public void move(Vector delta) {
        this.p1 = this.p1.add(delta);
        this.p2 = this.p2.add(delta);
    }

    @Override
    public Vector getPos() {
        return this.p1;
    }

    public void setP1(Vector p1) {
        this.p1 = p1;
    }

    public void setP2(Vector p2) {
        this.p2 = p2;
    }

    public boolean contains(Vector v) {
        if (this.p1.x == this.p2.x && this.p1.x == v.x) {
            return this.p1.y < v.y && v.y < this.p2.y || this.p2.y < v.y && v.y < this.p1.y;
        }
        if (this.p1.y == this.p2.y && this.p1.y == v.y) {
            return this.p1.x < v.x && v.x < this.p2.x || this.p2.x < v.x && v.x < this.p1.x;
        }
        return false;
    }

    public boolean contains(Vector v, int radius) {
        if (this.p1.x == this.p2.x) {
            return Math.abs(this.p1.x - v.x) < radius && (this.p1.y - radius < v.y && v.y < this.p2.y + radius || this.p2.y - radius < v.y && v.y < this.p1.y + radius);
        }
        if (this.p1.y == this.p2.y) {
            return Math.abs(this.p1.y - v.y) < radius && (this.p1.x - radius < v.x && v.x < this.p2.x + radius || this.p2.x - radius < v.x && v.x < this.p1.x + radius);
        }
        if (v.x < Math.min(this.p1.x, this.p2.x) - radius) {
            return false;
        }
        if (v.x > Math.max(this.p1.x, this.p2.x) + radius) {
            return false;
        }
        if (v.y < Math.min(this.p1.y, this.p2.y) - radius) {
            return false;
        }
        if (v.y > Math.max(this.p1.y, this.p2.y) + radius) {
            return false;
        }
        Vector d = this.p2.sub(this.p1);
        int z = d.x * (this.p1.y - v.y) + d.y * (v.x - this.p1.x);
        int dist = z * z / (d.x * d.x + d.y * d.y);
        return dist < radius * radius;
    }

    public boolean isPosOnWire(Vector pos) {
        switch (this.getOrientation()) {
            case vertical: {
                if (this.p1.x == pos.x && (this.p1.y <= pos.y && pos.y <= this.p2.y || this.p2.y <= pos.y && pos.y <= this.p1.y)) {
                    return true;
                }
            }
            case horizontal: {
                if (this.p1.y == pos.y && (this.p1.x <= pos.x && pos.x <= this.p2.x || this.p2.x <= pos.x && pos.x <= this.p1.x)) {
                    return true;
                }
            }
            case diagonal: {
                if (!pos.equals(this.p1) && !pos.equals(this.p2)) break;
                return true;
            }
        }
        return false;
    }

    public float distance(Vector v) {
        Vector ds = this.p2.sub(this.p1);
        float len = ds.len();
        VectorFloat d = ds.mul(1.0f / len);
        VectorFloat p = v.sub(this.p1).toFloat();
        float s = p.mul(d);
        if (s < 0.0f) {
            return v.sub(this.p1).len();
        }
        if (s > len) {
            return v.sub(this.p2).len();
        }
        return d.mul(s).sub(p).len();
    }

    public Orientation getOrientation() {
        if (this.p1.x == this.p2.x) {
            return Orientation.vertical;
        }
        if (this.p1.y == this.p2.y) {
            return Orientation.horizontal;
        }
        return Orientation.diagonal;
    }

    public boolean isIncludedIn(Collection<Wire> col) {
        for (Wire w : col) {
            if (!this.equalsContent(w)) continue;
            return true;
        }
        return false;
    }

    public boolean equalsContent(Wire wire) {
        if (this == wire) {
            return true;
        }
        if (wire == null) {
            return false;
        }
        if (!this.p1.equals(wire.p1)) {
            return false;
        }
        return this.p2.equals(wire.p2);
    }

    public String toString() {
        return "Wire{p1=" + this.p1 + ", p2=" + this.p2 + '}';
    }

    public void setValue(ObservableValue value) {
        this.observableValue = value;
    }

    public ObservableValue getValue() {
        return this.observableValue;
    }

    public void noDot() {
        this.p1Dot = false;
        this.p2Dot = false;
        this.bits = 0;
        this.isConnectedToSplitter = false;
    }

    public void setDot(Vector p) {
        if (p.equals(this.p1)) {
            this.p1Dot = true;
        }
        if (p.equals(this.p2)) {
            this.p2Dot = true;
        }
    }

    public Movable getMovableP1() {
        return new Movable(){

            @Override
            public void move(Vector delta) {
                Wire.this.p1 = Wire.this.p1.add(delta);
            }

            @Override
            public Vector getPos() {
                return Wire.this.p1;
            }
        };
    }

    public Movable getMovableP2() {
        return new Movable(){

            @Override
            public void move(Vector delta) {
                Wire.this.p2 = Wire.this.p2.add(delta);
            }

            @Override
            public Vector getPos() {
                return Wire.this.p2;
            }
        };
    }

    public void setIsConnectedToSplitter(boolean isConnectedToSplitter) {
        this.isConnectedToSplitter = isConnectedToSplitter;
    }

    static enum Orientation {
        horizontal,
        vertical,
        diagonal;

    }
}

