/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.draw.elements;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Pins
implements Iterable<Pin> {
    private final HashMap<String, Pin> inputs = new HashMap();
    private final HashMap<String, Pin> outputs = new HashMap();
    private final ArrayList<Pin> allPins = new ArrayList();

    public Pins add(Pin pin) {
        if (pin.getDirection() == PinDescription.Direction.input) {
            this.inputs.put(pin.getName(), pin);
        } else {
            this.outputs.put(pin.getName(), pin);
        }
        this.allPins.add(pin);
        return this;
    }

    @Override
    public Iterator<Pin> iterator() {
        return this.allPins.iterator();
    }

    public void bindOutputsToOutputPins(ObservableValues outs) throws PinException {
        for (ObservableValue o : outs) {
            Pin pin = this.outputs.get(o.getName());
            if (pin == null) {
                throw new PinException(Lang.get("err_pin_N_unknown", o.getName()));
            }
            pin.setValue(o);
        }
    }

    public HashMap<String, Pin> getInputs() {
        return this.inputs;
    }

    public int size() {
        return this.allPins.size();
    }

    public Pin get(int index) {
        return this.allPins.get(index);
    }
}

