/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.data;

import de.neemann.digital.StringList;
import de.neemann.digital.core.IntFormat;
import de.neemann.digital.core.Observable;
import de.neemann.digital.core.ValueFormatter;
import de.neemann.digital.data.Value;
import de.neemann.digital.testing.parser.TestRow;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class ValueTable
extends Observable
implements Iterable<TestRow> {
    private final String[] names;
    private final ArrayList<TestRow> values;
    private ArrayList<Integer> tableRowIndex;
    private final long[] max;
    private int maxSize = 0;

    public ValueTable(ArrayList<String> names) {
        this(names.toArray(new String[names.size()]));
    }

    public ValueTable(String ... names) {
        this.names = names;
        this.values = new ArrayList();
        this.max = new long[names.length];
    }

    public ValueTable(ValueTable toCopy) {
        this.names = toCopy.names;
        this.values = (ArrayList)toCopy.values.clone();
        this.max = (long[])toCopy.max.clone();
    }

    public int getRows() {
        return this.values.size();
    }

    public int getTableRows() {
        if (this.tableRowIndex == null) {
            return this.values.size();
        }
        return this.tableRowIndex.size();
    }

    public ValueTable add(TestRow row) {
        if (this.maxSize > 0 && this.values.size() >= this.maxSize) {
            if (this.tableRowIndex != null) {
                throw new RuntimeException("delete not allowed if table index is present");
            }
            while (this.values.size() >= this.maxSize) {
                this.values.remove(0);
            }
        }
        if (this.tableRowIndex != null) {
            this.tableRowIndex.add(this.values.size());
        }
        this.values.add(row);
        this.checkMax(row.getValues());
        this.fireHasChanged();
        return this;
    }

    public ValueTable omitInTable() {
        if (this.tableRowIndex == null) {
            this.tableRowIndex = new ArrayList();
            for (int i = 0; i < this.values.size(); ++i) {
                this.tableRowIndex.add(i);
            }
        }
        this.tableRowIndex.remove(this.tableRowIndex.size() - 1);
        return this;
    }

    private void checkMax(Value[] row) {
        for (int i = 0; i < row.length; ++i) {
            if (Long.compareUnsigned(this.max[i], row[i].getValue()) >= 0) continue;
            this.max[i] = row[i].getValue();
        }
    }

    public Value getValue(int rowIndex, int columnIndex) {
        return this.values.get(rowIndex).getValue(columnIndex);
    }

    public Value getTableValue(int rowIndex, int columnIndex) {
        return this.getTableRow(rowIndex).getValue(columnIndex);
    }

    public TestRow getTableRow(int rowIndex) {
        if (this.tableRowIndex == null) {
            return this.values.get(rowIndex);
        }
        return this.values.get(this.tableRowIndex.get(rowIndex));
    }

    public String getDescription(int rowIndex) {
        if (this.tableRowIndex == null) {
            return this.values.get(rowIndex).getDescription();
        }
        return this.values.get(this.tableRowIndex.get(rowIndex)).getDescription();
    }

    public int getColumns() {
        return this.names.length;
    }

    public String getColumnName(int col) {
        return this.names[col];
    }

    @Override
    public Iterator<TestRow> iterator() {
        return this.values.iterator();
    }

    public long getMax(int col) {
        return this.max[col];
    }

    public void saveCSV(File file) throws IOException {
        this.saveCSV(file, null);
    }

    public void saveCSV(File file, ColumnInfo[] columnInfo) throws IOException {
        this.saveCSV(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), columnInfo);
    }

    public void saveCSV(BufferedWriter w) throws IOException {
        this.saveCSV(w, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveCSV(BufferedWriter w, ColumnInfo[] columnInfo) throws IOException {
        try {
            w.write("\"step\"");
            for (String s : this.names) {
                w.write(",\"" + s + '\"');
            }
            w.write("\n");
            int row = 0;
            for (TestRow s : this) {
                w.write("\"" + row++ + "\"");
                if (columnInfo == null) {
                    for (Value value : s.getValues()) {
                        w.write(",\"" + value + "\"");
                    }
                } else {
                    int i = 0;
                    for (Value value : s.getValues()) {
                        w.write(",\"" + columnInfo[i++].format(value) + "\"");
                    }
                }
                w.write("\n");
            }
        }
        finally {
            w.close();
        }
    }

    public void clear() {
        this.values.clear();
        Arrays.fill(this.max, 0L);
        this.fireHasChanged();
    }

    public ValueTable setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringList sl = new StringList(sb);
        for (String n : this.names) {
            sl.add(n);
        }
        sb.append("\n");
        if (this.tableRowIndex == null) {
            for (TestRow row : this.values) {
                sl = new StringList(sb);
                for (Value v : row.getValues()) {
                    sl.add(v.toString());
                }
                sb.append("\n");
            }
        } else {
            Iterator<Integer> iterator = this.tableRowIndex.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                sl = new StringList(sb);
                for (Value v : this.values.get(i).getValues()) {
                    sl.add(v.toString());
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static final class ColumnInfo {
        private final int bits;
        private final ValueFormatter format;

        public ColumnInfo(ValueFormatter format, int bits) {
            if (format == null) {
                format = IntFormat.HEX_FORMATTER;
            } else if (format.equals(IntFormat.DEFAULT_FORMATTER) && bits > 3) {
                format = IntFormat.HEX_FORMATTER;
            }
            this.format = format;
            this.bits = bits;
        }

        private String format(Value value) {
            switch (value.getType()) {
                case HIGHZ: {
                    return "Z";
                }
                case DONTCARE: {
                    return "X";
                }
                case CLOCK: {
                    return "C";
                }
            }
            return this.format.formatToEdit(new de.neemann.digital.core.Value(value.getValue(), this.bits));
        }
    }
}

