/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.data;

import de.neemann.digital.core.IntFormat;
import de.neemann.digital.core.SyncAccess;
import de.neemann.digital.data.Value;
import de.neemann.digital.data.ValueTable;
import de.neemann.digital.draw.graphics.Graphic;
import de.neemann.digital.draw.graphics.Orientation;
import de.neemann.digital.draw.graphics.Style;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.Drawable;
import de.neemann.digital.testing.parser.TestRow;
import javax.swing.JScrollBar;

public class DataPlotter
implements Drawable {
    private final ValueTable dataOriginal;
    private final int textWidth;
    private final SyncAccess modelSync;
    private double size = 25.0;
    private int xOffset = 0;
    private int yOffset;
    private int width = 0;
    private int height = 0;
    private boolean manualScaling = false;
    private JScrollBar horizontalScrollBar;
    private int autoScaleOffset;
    private JScrollBar verticalScrollBar;
    private static final int BORDER = 10;
    private static final int SIZE = 25;
    private static final int CENTER = 12;
    private static final int SEP2 = 5;
    private static final int SEP = 10;

    public DataPlotter(ValueTable data, SyncAccess modelSync) {
        this.dataOriginal = data;
        this.modelSync = modelSync;
        int tl = 0;
        for (int i = 0; i < data.getColumns(); ++i) {
            String text = data.getColumnName(i);
            int w = text.length();
            if (w <= tl) continue;
            tl = w;
        }
        this.textWidth = tl * Style.NORMAL.getFontSize() / 2 + 10 + 10;
    }

    public void fitInside() {
        this.modelSync.read(() -> {
            this.size = (double)(this.width - this.textWidth) / (double)this.dataOriginal.getRows();
        });
        this.xOffset = 0;
        this.manualScaling = false;
    }

    public void scale(double f, int xPos) {
        double p = (double)(xPos - this.textWidth + this.xOffset) / this.size;
        this.size *= f;
        if (this.size < (double)Style.NORMAL.getThickness()) {
            this.size = Style.NORMAL.getThickness();
        }
        if (this.size > 150.0) {
            this.size = 150.0;
        }
        this.xOffset = (int)(p * this.size - (double)xPos + (double)this.textWidth);
        this.manualScaling = true;
    }

    public void move(int dx, int dy) {
        this.xOffset -= dx;
        this.manualScaling = dx >= 0 || this.xOffset < this.autoScaleOffset;
        this.yOffset -= dy;
        if (this.yOffset < 0) {
            this.yOffset = 0;
        }
    }

    @Override
    public void drawTo(Graphic g, Style highLight) {
        boolean staticData = this.modelSync == SyncAccess.NOSYNC;
        ValueTable data = staticData ? this.dataOriginal : this.modelSync.read(new Runnable(){
            private ValueTable data;

            @Override
            public void run() {
                this.data = new ValueTable(DataPlotter.this.dataOriginal);
            }
        }).data;
        int availDataWidth = this.width - this.textWidth;
        int preferredDataWidth = (int)(this.size * (double)data.getRows());
        this.autoScaleOffset = preferredDataWidth - availDataWidth + 2;
        if (!this.manualScaling && this.width > 0 && !staticData && this.autoScaleOffset > 0) {
            this.xOffset = this.autoScaleOffset;
        }
        int signals = data.getColumns();
        if (this.horizontalScrollBar != null) {
            this.horizontalScrollBar.setValues(this.xOffset, availDataWidth, 0, preferredDataWidth);
        }
        if (signals * 35 + 20 - this.yOffset < this.height) {
            this.yOffset = signals * 35 + 20 - this.height;
            if (this.yOffset < 0) {
                this.yOffset = 0;
            }
        }
        if (this.verticalScrollBar != null) {
            this.verticalScrollBar.setValues(this.yOffset, this.height, 0, signals * 35 + 20);
        }
        int dataAreaWidth = availDataWidth;
        if (this.width == 0) {
            dataAreaWidth = preferredDataWidth - this.xOffset;
        }
        int yTextOffs = 12;
        int y = 10 - this.yOffset;
        int textPos = this.textWidth;
        if (this.xOffset < 0) {
            textPos = this.textWidth - this.xOffset;
        }
        for (int i = 0; i < signals; ++i) {
            String text = data.getColumnName(i);
            g.drawText(new Vector(textPos - 2, y + yTextOffs), text, Orientation.RIGHTCENTER, Style.NORMAL);
            g.drawLine(new Vector(textPos, y - 5), new Vector(this.textWidth + dataAreaWidth, y - 5), Style.DASH);
            y += 35;
        }
        g.drawLine(new Vector(textPos, y - 5), new Vector(this.textWidth + dataAreaWidth, y - 5), Style.DASH);
        LastState[] last = new LastState[signals];
        for (int i = 0; i < signals; ++i) {
            last[i] = new LastState();
        }
        boolean first = true;
        double pos = 0.0;
        for (TestRow s : data) {
            int x1 = (int)(pos + (double)this.textWidth - (double)this.xOffset);
            int x2 = (int)(pos + (double)this.textWidth - (double)this.xOffset + this.size);
            if (x2 > this.textWidth && x1 < this.textWidth + dataAreaWidth) {
                if (x1 < this.textWidth) {
                    x1 = this.textWidth;
                }
                if (x2 > this.textWidth + dataAreaWidth) {
                    x2 = this.textWidth + dataAreaWidth;
                }
                g.drawLine(new Vector(x1, 5 - this.yOffset), new Vector(x1, 35 * signals + 10 - 5 - this.yOffset), Style.DASH);
                y = 10 - this.yOffset;
                for (int i = 0; i < signals; ++i) {
                    Style style;
                    switch (s.getValue(i).getState()) {
                        case FAIL: {
                            style = Style.FAILED;
                            break;
                        }
                        case PASS: {
                            style = Style.PASS;
                            break;
                        }
                        default: {
                            style = Style.NORMAL;
                        }
                    }
                    long width = data.getMax(i);
                    if (width == 0L) {
                        width = 1L;
                    }
                    long value = s.getValue(i).getValue();
                    boolean isHighZ = s.getValue(i).isHighZ();
                    long sWidth = width >>> 32;
                    int ry = sWidth == 0L ? (int)(25L - 25L * value / width) : (int)(25L - 25L * (value >>> 32) / sWidth);
                    if (value != last[i].value) {
                        last[i].hasChanged = true;
                    }
                    if (width > 4L && last[i].textWidth == 0 && last[i].hasChanged) {
                        String text = IntFormat.toShortHex(value);
                        last[i].textWidth = text.length() * 25 / 2;
                        if (ry > 12) {
                            g.drawText(new Vector(x1 + 1, y - 5 + 1), text, Orientation.LEFTTOP, Style.SHAPE_PIN);
                        } else {
                            g.drawText(new Vector(x1 + 1, y + 25 + 5 - 1), text, Orientation.LEFTBOTTOM, Style.SHAPE_PIN);
                        }
                        last[i].hasChanged = false;
                    }
                    if (!s.getValue(i).getType().equals((Object)Value.Type.HIGHZ)) {
                        g.drawLine(new Vector(x1, y + ry), new Vector(x2, y + ry), style);
                    }
                    if (!(first || ry == last[i].y || isHighZ || last[i].isHighZ)) {
                        g.drawLine(new Vector(x1, y + last[i].y), new Vector(x1, y + ry), style);
                    }
                    if (!first && value != last[i].value && Math.abs(ry - last[i].y) < 5) {
                        g.drawLine(new Vector(x1, y + ry - 5), new Vector(x1, y + ry + 5), Style.NORMAL);
                    }
                    last[i].y = ry;
                    last[i].value = value;
                    last[i].isHighZ = isHighZ;
                    last[i].decTextWidth(x2 - x1);
                    y += 35;
                }
                first = false;
            }
            if (this.width > 0 && x1 > this.width) break;
            pos += this.size;
        }
        g.drawLine(new Vector(this.textWidth + dataAreaWidth, 5 - this.yOffset), new Vector(this.textWidth + dataAreaWidth, 35 * signals + 10 - 5 - this.yOffset), Style.DASH);
    }

    public int getGraphicHeight() {
        return this.dataOriginal.getColumns() * 35 + 20;
    }

    public int getCurrentGraphicWidth() {
        return this.modelSync.read(new Runnable(){
            private int r;

            @Override
            public void run() {
                this.r = DataPlotter.this.textWidth + (int)((double)(DataPlotter.this.dataOriginal.getRows() + 1) * DataPlotter.this.size);
            }
        }).r;
    }

    public void setWidth(int width) {
        this.width = width;
        if (this.horizontalScrollBar != null) {
            this.horizontalScrollBar.setVisibleAmount(width - this.textWidth);
        }
    }

    public void setHeight(int height) {
        this.height = height;
        if (this.verticalScrollBar != null) {
            this.verticalScrollBar.setVisibleAmount(height);
        }
    }

    public void setHorizontalScrollBar(JScrollBar scrollBar) {
        this.horizontalScrollBar = scrollBar;
    }

    public void setVerticalScrollBar(JScrollBar scrollBar) {
        this.verticalScrollBar = scrollBar;
    }

    public boolean setNewXOffset(int value) {
        if (this.xOffset != value) {
            this.xOffset = value;
            this.manualScaling = this.horizontalScrollBar == null || this.horizontalScrollBar.getMaximum() - this.horizontalScrollBar.getVisibleAmount() != this.xOffset;
            return true;
        }
        return false;
    }

    public boolean setNewYOffset(int value) {
        if (this.yOffset != value) {
            this.yOffset = value;
            return true;
        }
        return false;
    }

    private static final class LastState {
        private long value;
        private boolean isHighZ;
        private int y;
        private int textWidth;
        private boolean hasChanged = true;

        private LastState() {
        }

        private void decTextWidth(int size) {
            if (this.textWidth > 0) {
                this.textWidth -= size;
                if (this.textWidth < 0) {
                    this.textWidth = 0;
                }
            }
        }
    }
}

