/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring.bus;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.wiring.bus.AbstractBusHandler;
import de.neemann.digital.core.wiring.bus.BusModelStateObserver;
import java.util.Arrays;
import java.util.List;

public final class SingleBusHandler
extends AbstractBusHandler {
    private final ObservableValue output;
    private final PinDescription.PullResistor resistor;
    private final List<ObservableValue> inputs;

    public SingleBusHandler(BusModelStateObserver obs, ObservableValue output, PinDescription.PullResistor resistor, ObservableValue ... inputs) {
        super(obs);
        this.output = output;
        this.resistor = resistor;
        this.inputs = Arrays.asList(inputs);
    }

    @Override
    public List<ObservableValue> getInputs() {
        return this.inputs;
    }

    @Override
    public PinDescription.PullResistor getResistor() {
        return this.resistor;
    }

    @Override
    public void set(long value, long highz) {
        this.output.set(value, highz);
    }

    @Override
    public ObservableValues getAllValues() {
        return new ObservableValues.Builder().add(this.getInputs()).add(this.output).build();
    }
}

