/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring.bus;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.wiring.bus.BusModelStateObserver;
import de.neemann.digital.core.wiring.bus.CommonBusValue;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.model.Net;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;

public class DataBus {
    private final CommonBusValue commonBusValue;

    public DataBus(Net net, Model model, ArrayList<Pin> outputs) throws PinException {
        this(net, model, DataBus.createArray(outputs));
    }

    private static ObservableValue[] createArray(ArrayList<Pin> outputs) {
        ObservableValue[] o = new ObservableValue[outputs.size()];
        for (int i = 0; i < outputs.size(); ++i) {
            o[i] = outputs.get(i).getValue();
        }
        return o;
    }

    public DataBus(Net net, Model model, ObservableValue ... outputs) throws PinException {
        int bits = 0;
        PinDescription.PullResistor resistor = PinDescription.PullResistor.none;
        block4: for (ObservableValue o : outputs) {
            int b = o.getBits();
            if (bits == 0) {
                bits = b;
            } else if (bits != b) {
                throw new PinException(Lang.get("err_notAllOutputsSameBits", new Object[0]), net);
            }
            switch (o.getPullResistor()) {
                case pullDown: {
                    if (resistor == PinDescription.PullResistor.pullUp) {
                        throw new PinException(Lang.get("err_pullUpAndDownNotAllowed", new Object[0]), net);
                    }
                    resistor = PinDescription.PullResistor.pullDown;
                    continue block4;
                }
                case pullUp: {
                    if (resistor == PinDescription.PullResistor.pullDown) {
                        throw new PinException(Lang.get("err_pullUpAndDownNotAllowed", new Object[0]), net);
                    }
                    resistor = PinDescription.PullResistor.pullUp;
                }
            }
        }
        BusModelStateObserver obs = model.getOrCreateObserver(BusModelStateObserver.class, BusModelStateObserver::new);
        this.commonBusValue = new CommonBusValue(bits, obs, resistor, outputs, net == null ? null : net.getOrigin());
        for (ObservableValue p : outputs) {
            p.addObserverToValue(this.commonBusValue);
        }
        this.commonBusValue.hasChanged();
    }

    public ObservableValue getReadableOutput() {
        return this.commonBusValue;
    }
}

