/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring.bus;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.wiring.bus.AbstractBusHandler;
import de.neemann.digital.core.wiring.bus.BusModelStateObserver;
import de.neemann.digital.core.wiring.bus.CommonBusValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ConnectedBusHandler
extends AbstractBusHandler {
    private PinDescription.PullResistor resistor = PinDescription.PullResistor.none;
    private final ArrayList<CommonBusValue> values = new ArrayList();
    private final ArrayList<ObservableValue> inputs = new ArrayList();
    private final ArrayList<ObservableValue> excludes = new ArrayList();

    public ConnectedBusHandler(BusModelStateObserver obs) {
        super(obs);
    }

    public void addNet(CommonBusValue commonBusValue) {
        this.values.add(commonBusValue);
        this.inputs.addAll(Arrays.asList(commonBusValue.getInputs()));
        if (!commonBusValue.getResistor().equals((Object)PinDescription.PullResistor.none)) {
            if (this.resistor.equals((Object)PinDescription.PullResistor.none)) {
                this.resistor = commonBusValue.getResistor();
            } else if (!this.resistor.equals((Object)commonBusValue.getResistor())) {
                this.resistor = PinDescription.PullResistor.both;
            }
        }
        commonBusValue.setHandler(this);
        this.addOrigin(commonBusValue.getOrigin());
    }

    public void addNet(ConnectedBusHandler h2) {
        for (CommonBusValue cbv : h2.values) {
            this.addNet(cbv);
        }
    }

    @Override
    public List<ObservableValue> getInputs() {
        return this.inputs;
    }

    @Override
    public PinDescription.PullResistor getResistor() {
        return this.resistor;
    }

    @Override
    public void set(long value, long highz) {
        for (ObservableValue observableValue : this.values) {
            observableValue.set(value, highz);
        }
    }

    @Override
    public ObservableValues getAllValues() {
        return new ObservableValues.Builder().add(this.getInputs()).add(this.values).build();
    }

    public ArrayList<CommonBusValue> getValues() {
        return this.values;
    }

    public String toString() {
        return "ConnectedBusHandler{values=" + this.values + '}';
    }

    public void addExclude(ObservableValue output1, ObservableValue output2) {
        this.excludes.add(output1);
        this.excludes.add(output2);
    }

    public void addExcludesFrom(ConnectedBusHandler other) {
        this.excludes.addAll(other.excludes);
    }

    public void removeExcludes() {
        this.inputs.removeAll(this.excludes);
    }
}

