/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring.bus;

import de.neemann.digital.core.ModelEvent;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.ModelStateObserverTyped;
import de.neemann.digital.core.switching.PlainSwitch;
import de.neemann.digital.core.wiring.bus.AbstractBusHandler;
import de.neemann.digital.core.wiring.bus.CommonBusValue;
import de.neemann.digital.core.wiring.bus.ConnectedBusHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public final class BusModelStateObserver
implements ModelStateObserverTyped {
    private final ArrayList<AbstractBusHandler> busList = new ArrayList();
    private final HashSet<PlainSwitch.RealSwitch> closedSwitches = new HashSet();
    private int version;

    BusModelStateObserver() {
    }

    @Override
    public void handleEvent(ModelEvent event) {
        if (!(event != ModelEvent.STEP && event != ModelEvent.CHECKBURN || this.busList.isEmpty())) {
            for (AbstractBusHandler bus : this.busList) {
                bus.checkBurn();
            }
            this.busList.clear();
            ++this.version;
        }
    }

    @Override
    public ModelEventType[] getEvents() {
        return new ModelEventType[]{ModelEventType.STEP, ModelEventType.CHECKBURN};
    }

    public int getVersion() {
        return this.version;
    }

    public void addCheck(AbstractBusHandler commonBusValue) {
        this.busList.add(commonBusValue);
    }

    public void setClosed(PlainSwitch.RealSwitch realSwitch, boolean closed) {
        if (closed) {
            this.closedSwitches.add(realSwitch);
        } else {
            this.closedSwitches.remove(realSwitch);
            realSwitch.getInput1().resetHandler();
            realSwitch.getInput2().resetHandler();
        }
        this.reconfigureNets();
    }

    private void reconfigureNets() {
        this.busList.removeIf(abstractBusHandler -> abstractBusHandler instanceof ConnectedBusHandler);
        HashMap<CommonBusValue, ConnectedBusHandler> netMap = new HashMap<CommonBusValue, ConnectedBusHandler>();
        ArrayList<ConnectedBusHandler> createdHandlers = new ArrayList<ConnectedBusHandler>();
        for (PlainSwitch.RealSwitch s : this.closedSwitches) {
            ConnectedBusHandler h1 = (ConnectedBusHandler)netMap.get(s.getInput1());
            ConnectedBusHandler h2 = (ConnectedBusHandler)netMap.get(s.getInput2());
            if (h1 == null) {
                if (h2 == null) {
                    ConnectedBusHandler h = new ConnectedBusHandler(this);
                    createdHandlers.add(h);
                    h.addNet(s.getInput1());
                    h.addNet(s.getInput2());
                    h.addExclude(s.getOutput1(), s.getOutput2());
                    netMap.put(s.getInput1(), h);
                    netMap.put(s.getInput2(), h);
                    continue;
                }
                h2.addNet(s.getInput1());
                h2.addExclude(s.getOutput1(), s.getOutput2());
                netMap.put(s.getInput1(), h2);
                continue;
            }
            if (h2 == null) {
                h1.addNet(s.getInput2());
                h1.addExclude(s.getOutput1(), s.getOutput2());
                netMap.put(s.getInput2(), h1);
                continue;
            }
            if (h1 == h2) continue;
            h1.addNet(h2);
            h1.addExcludesFrom(h2);
            for (CommonBusValue v : h2.getValues()) {
                netMap.put(v, h1);
            }
            createdHandlers.remove(h2);
        }
        for (ConnectedBusHandler h : createdHandlers) {
            h.removeExcludes();
        }
        for (ConnectedBusHandler h : createdHandlers) {
            h.recalculate();
        }
    }
}

