/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.lang.Lang;

public class PriorityEncoder
extends Node
implements Element,
Countable {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(PriorityEncoder.class, new PinDescription[0]){

        @Override
        public PinDescriptions getInputDescription(ElementAttributes elementAttributes) {
            int inputs = 1 << elementAttributes.get(Keys.SELECTOR_BITS);
            PinDescription[] names = new PinDescription[inputs];
            for (int i = 0; i < inputs; ++i) {
                names[i] = PinInfo.input("in" + i, Lang.get("elem_PriorityEncoder_input", i));
            }
            return new PinDescriptions(names);
        }
    }.addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.SELECTOR_BITS).supportsHDL();
    private final ObservableValue selOut;
    private final ObservableValue anyOut;
    private final int inputCount;
    private ObservableValues inputs;
    private long sel;
    private boolean any;

    public PriorityEncoder(ElementAttributes attributes) {
        int outBits = attributes.get(Keys.SELECTOR_BITS);
        this.inputCount = 1 << outBits;
        this.selOut = new ObservableValue("num", outBits).setPinDescription(DESCRIPTION);
        this.anyOut = new ObservableValue("any", 1).setPinDescription(DESCRIPTION);
    }

    @Override
    public void readInputs() throws NodeException {
        this.sel = 0L;
        this.any = false;
        for (int i = 0; i < this.inputCount; ++i) {
            if (!((ObservableValue)this.inputs.get(i)).getBool()) continue;
            this.sel = i;
            this.any = true;
        }
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.selOut.setValue(this.sel);
        this.anyOut.setBool(this.any);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.inputs = inputs;
        for (int i = 0; i < this.inputCount; ++i) {
            ((ObservableValue)inputs.get(i)).addObserverToValue(this).checkBits(1, this, i);
        }
    }

    @Override
    public ObservableValues getOutputs() throws PinException {
        return new ObservableValues(this.selOut, this.anyOut);
    }

    @Override
    public int getDataBits() {
        return 1;
    }

    @Override
    public int getInputsCount() {
        return this.inputCount;
    }
}

