/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring;

import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.basic.FanIn;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.lang.Lang;

public class Multiplexer
extends FanIn {
    private final int selectorBits;
    private ObservableValue selector;
    private long value;
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Multiplexer.class, new PinDescription[0]){

        @Override
        public PinDescriptions getInputDescription(ElementAttributes elementAttributes) {
            int size = 1 << elementAttributes.get(Keys.SELECTOR_BITS);
            PinDescription[] names = new PinDescription[size + 1];
            names[0] = PinInfo.input("sel", Lang.get("elem_Multiplexer_pin_sel", new Object[0]));
            for (int i = 0; i < size; ++i) {
                names[i + 1] = PinInfo.input("in_" + i, Lang.get("elem_Multiplexer_input", i));
            }
            return new PinDescriptions(names);
        }
    }.addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.SELECTOR_BITS).addAttribute(Keys.FLIP_SEL_POSITON).supportsHDL();

    public Multiplexer(ElementAttributes attributes) {
        super(attributes.get(Keys.BITS));
        this.selectorBits = attributes.get(Keys.SELECTOR_BITS);
        this.getOutput().setDescription(Lang.get("elem_Multiplexer_output", new Object[0]));
    }

    @Override
    public void readInputs() throws NodeException {
        int n = (int)this.selector.getValue();
        this.value = this.getInputs().get(n).getValue();
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.getOutput().setValue(this.value);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.selector = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(this.selectorBits, this);
        ObservableValues in = new ObservableValues(inputs, 1, inputs.size());
        super.setInputs(in);
        if (in.size() != 1 << this.selectorBits) {
            throw new BitsException(Lang.get("err_selectorInputCountMismatch", new Object[0]), (Node)this, -1, this.selector);
        }
    }

    @Override
    public int getAddrBits() {
        return this.selectorBits;
    }
}

