/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.Collection;

public class Decoder
extends Node
implements Element,
Countable {
    private final int selectorBits;
    private final ObservableValues output;
    private ObservableValue selector;
    private int oldSelectorValue;
    private int selectorValue;
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Decoder.class, PinInfo.input("sel")).addAttribute(Keys.ROTATE).addAttribute(Keys.SELECTOR_BITS).addAttribute(Keys.FLIP_SEL_POSITON).supportsHDL();

    public Decoder(ElementAttributes attributes) {
        this.selectorBits = attributes.get(Keys.SELECTOR_BITS);
        int outputs = 1 << this.selectorBits;
        ArrayList<ObservableValue> o = new ArrayList<ObservableValue>(outputs);
        for (int i = 0; i < outputs; ++i) {
            o.add(new ObservableValue("out_" + i, 1).setValue(0L).setDescription(Lang.get("elem_Decoder_output", i)));
        }
        this.output = new ObservableValues((Collection<ObservableValue>)o);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output;
    }

    @Override
    public void readInputs() throws NodeException {
        this.selectorValue = (int)this.selector.getValue();
    }

    @Override
    public void writeOutputs() throws NodeException {
        ((ObservableValue)this.output.get(this.oldSelectorValue)).setValue(0L);
        ((ObservableValue)this.output.get(this.selectorValue)).setValue(1L);
        this.oldSelectorValue = this.selectorValue;
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.selector = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(this.selectorBits, this);
    }

    @Override
    public int getDataBits() {
        return 1;
    }

    @Override
    public int getAddrBits() {
        return this.selectorBits;
    }
}

