/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.lang.Lang;

public class Clock
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription("Clock", Clock.class, new PinDescription[0]).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.RUN_AT_REAL_TIME).addAttribute(Keys.FREQUENCY).addAttribute(Keys.PINNUMBER).addAttribute(Keys.IN_OUT_SMALL).supportsHDL();
    private final ObservableValue output = new ObservableValue("C", 1).setPinDescription(DESCRIPTION);
    private final int frequency;
    private final String label;
    private final String clockPin;

    public Clock(ElementAttributes attributes) {
        if (attributes.get(Keys.RUN_AT_REAL_TIME).booleanValue()) {
            int f = attributes.get(Keys.FREQUENCY);
            if (f < 1) {
                f = 1;
            }
            this.frequency = f;
        } else {
            this.frequency = 0;
        }
        this.label = attributes.getLabel();
        this.clockPin = attributes.get(Keys.PINNUMBER);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        throw new NodeException(Lang.get("err_noInputsAvailable", new Object[0]), new ObservableValue[0]);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }

    @Override
    public void registerNodes(Model model) {
        model.addClock(this);
        model.addSignal(new Signal(this.label, this.output));
    }

    public ObservableValue getClockOutput() {
        return this.output;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public String getLabel() {
        return this.label;
    }

    public String getClockPin() {
        return this.clockPin;
    }
}

