/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.lang.Lang;

public class BusSplitter
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(BusSplitter.class, PinInfo.input("OE")).addAttribute(Keys.ROTATE).addAttribute(Keys.MIRROR).addAttribute(Keys.BITS).addAttribute(Keys.SPLITTER_SPREADING);
    private final int bits;
    private final ObservableValue commonOut;
    private final ObservableValue[] out;
    private final ObservableValue[] in;
    private ObservableValue oeValue;
    private ObservableValue commonIn;
    private boolean oe;
    private long commonD;
    private long commonZ;
    private ObservableValues outputValues;

    public BusSplitter(ElementAttributes attr) {
        ObservableValues.Builder builder = new ObservableValues.Builder();
        this.bits = attr.getBits();
        this.commonOut = new ObservableValue("D", this.bits).setToHighZ().setBidirectional().setPinDescription(DESCRIPTION);
        builder.add(this.commonOut);
        this.out = new ObservableValue[this.bits];
        for (int i = 0; i < this.bits; ++i) {
            this.out[i] = new ObservableValue("D" + i, 1).setToHighZ().setBidirectional().setDescription(Lang.get("elem_BusSplitter_pin_D_N", i));
            builder.add(this.out[i]);
        }
        this.outputValues = builder.build();
        this.in = new ObservableValue[this.bits];
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.oeValue = ((ObservableValue)inputs.get(0)).checkBits(1, this).addObserverToValue(this);
        this.commonIn = ((ObservableValue)inputs.get(1)).checkBits(this.bits, this).addObserverToValue(this);
        for (int i = 0; i < this.bits; ++i) {
            this.in[i] = ((ObservableValue)inputs.get(i + 2)).checkBits(1, this).addObserverToValue(this);
        }
    }

    @Override
    public void readInputs() throws NodeException {
        this.oe = this.oeValue.getBool();
        if (this.oe) {
            this.commonD = this.commonIn.getValue();
            this.commonZ = this.commonIn.getHighZ();
        } else {
            this.commonD = 0L;
            this.commonZ = 0L;
            long mask = 1L;
            for (int i = 0; i < this.bits; ++i) {
                if (this.in[i].getBool()) {
                    this.commonD |= mask;
                }
                if (this.in[i].isHighZ()) {
                    this.commonZ |= mask;
                }
                mask <<= 1;
            }
        }
    }

    @Override
    public void writeOutputs() throws NodeException {
        if (this.oe) {
            this.commonOut.setToHighZ();
            long mask = 1L;
            for (int i = 0; i < this.bits; ++i) {
                if ((this.commonZ & mask) != 0L) {
                    this.out[i].setToHighZ();
                } else {
                    this.out[i].setBool((this.commonD & mask) != 0L);
                }
                mask <<= 1;
            }
        } else {
            for (int i = 0; i < this.bits; ++i) {
                this.out[i].setToHighZ();
            }
            this.commonOut.set(this.commonD, this.commonZ);
        }
    }

    @Override
    public ObservableValues getOutputs() throws PinException {
        return this.outputValues;
    }
}

