/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.wiring;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;

public class Break
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Break.class, PinInfo.input("brk")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.ENABLED).addAttribute(Keys.CYCLES);
    private final int cycles;
    private final String label;
    private final boolean enabled;
    private ObservableValue input;

    public Break(ElementAttributes attributes) {
        this.cycles = attributes.get(Keys.CYCLES);
        this.enabled = attributes.get(Keys.ENABLED);
        this.label = attributes.getLabel();
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.input = ((ObservableValue)inputs.get(0)).checkBits(1, null);
    }

    public ObservableValue getBreakInput() {
        return this.input;
    }

    public int getCycles() {
        return this.cycles;
    }

    @Override
    public ObservableValues getOutputs() {
        return ObservableValues.EMPTY_LIST;
    }

    @Override
    public void registerNodes(Model model) {
        model.addBreak(this);
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

