/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.switching;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.NodeInterface;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.stats.Countable;
import de.neemann.digital.core.switching.PlainSwitch;

public class Switch
implements Element,
NodeInterface,
Countable {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Switch.class, new PinDescription[0]).addAttribute(Keys.ROTATE).addAttribute(Keys.MIRROR).addAttribute(Keys.BITS).addAttribute(Keys.LABEL).addAttribute(Keys.POLES).addAttribute(Keys.CLOSED).addAttribute(Keys.SWITCH_ACTS_AS_INPUT);
    private final PlainSwitch[] poles;
    private final String label;
    private final boolean switchActsAsInput;
    private boolean closed;
    private ObservableValue value;

    public Switch(ElementAttributes attr) {
        this(attr, attr.get(Keys.CLOSED));
    }

    public Switch(ElementAttributes attr, boolean closed) {
        this.closed = closed;
        int bits = attr.getBits();
        int poleCount = attr.get(Keys.POLES);
        this.poles = new PlainSwitch[poleCount];
        for (int i = 0; i < poleCount; ++i) {
            this.poles[i] = new PlainSwitch(bits, closed, "A" + (i + 1), "B" + (i + 1));
        }
        this.label = attr.getLabel();
        this.switchActsAsInput = attr.get(Keys.SWITCH_ACTS_AS_INPUT);
    }

    @Override
    public ObservableValues getOutputs() {
        ObservableValues.Builder ov = new ObservableValues.Builder();
        for (PlainSwitch p : this.poles) {
            p.addOutputsTo(ov);
        }
        return ov.build();
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        int i = 0;
        for (PlainSwitch p : this.poles) {
            p.setInputs((ObservableValue)inputs.get(i), (ObservableValue)inputs.get(i + 1));
            i += 2;
        }
    }

    @Override
    public void init(Model model) {
        for (PlainSwitch p : this.poles) {
            p.init(model);
        }
    }

    @Override
    public void registerNodes(Model model) {
        if (this.switchActsAsInput && !this.label.isEmpty()) {
            this.value = new ObservableValue(this.label, 1);
            this.value.addObserver(new NodeInterface(){

                @Override
                public ObservableValues getOutputs() {
                    return Switch.this.value.asList();
                }

                @Override
                public void hasChanged() {
                    Switch.this.setClosed(Switch.this.value.getBool());
                }
            });
            model.addInput(new Signal(this.label, this.value));
        }
    }

    @Override
    public void hasChanged() {
        for (PlainSwitch p : this.poles) {
            p.hasChanged();
        }
    }

    public void setClosed(boolean closed) {
        if (this.closed != closed) {
            if (this.value != null) {
                this.value.setBool(closed);
            }
            this.closed = closed;
            for (PlainSwitch p : this.poles) {
                p.setClosed(closed);
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public int getDataBits() {
        return this.poles[0].getBits();
    }

    @Override
    public int getInputsCount() {
        return this.poles.length;
    }
}

