/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.switching;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.NodeInterface;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.switching.PlainSwitch;
import de.neemann.digital.lang.Lang;

public final class PlainSwitchDT
implements NodeInterface {
    private final ObservableValue outputA;
    private final ObservableValue outputB;
    private final ObservableValue outputC;
    private final int bits;
    private PlainSwitch.SwitchModel s1;
    private PlainSwitch.SwitchModel s2;
    private boolean closed = false;

    PlainSwitchDT(int bits, int num) {
        this.bits = bits;
        this.outputA = new ObservableValue("A" + num, bits).setBidirectional().setToHighZ().setDescription(Lang.get("elem_Switch_pin", new Object[0])).setSwitchPin(true);
        this.outputB = new ObservableValue("B" + num, bits).setBidirectional().setToHighZ().setDescription(Lang.get("elem_Switch_pin", new Object[0])).setSwitchPin(true);
        this.outputC = new ObservableValue("C" + num, bits).setBidirectional().setToHighZ().setDescription(Lang.get("elem_Switch_pin", new Object[0])).setSwitchPin(true);
    }

    public void setInputs(ObservableValue inA, ObservableValue inB, ObservableValue inC) throws NodeException {
        if (inA != null) {
            if (inB != null && inC == null) {
                inA.addObserverToValue(this).checkBits(this.bits, null);
                inB.addObserverToValue(this).checkBits(this.bits, null);
                this.s1 = PlainSwitch.createSwitchModel(inA, inB, this.outputA, this.outputB);
            } else if (inB == null && inC != null) {
                inA.addObserverToValue(this).checkBits(this.bits, null);
                inC.addObserverToValue(this).checkBits(this.bits, null);
                this.s2 = PlainSwitch.createSwitchModel(inA, inC, this.outputA, this.outputC);
            } else if (inB != null && inC != null) {
                inA.addObserverToValue(this).checkBits(this.bits, null);
                inB.addObserverToValue(this).checkBits(this.bits, null);
                inC.addObserverToValue(this).checkBits(this.bits, null);
                this.s1 = PlainSwitch.createSwitchModel(inA, inB, this.outputA, this.outputB);
                this.s2 = PlainSwitch.createSwitchModel(inA, inC, this.outputA, this.outputC);
                if (this.s1.isUniDirOutput(this.outputA) && this.s2.isUniDirOutput(this.outputA)) {
                    this.s1.dontTouchOpenContact();
                    this.s2.dontTouchOpenContact();
                }
            }
        }
    }

    public void init(Model model) {
        if (this.s1 != null) {
            this.s1.setModel(model);
            this.s1.setClosed(this.closed);
        }
        if (this.s2 != null) {
            this.s2.setModel(model);
            this.s2.setClosed(!this.closed);
        }
        this.hasChanged();
    }

    public void setClosed(boolean isClosed) {
        if (this.closed != isClosed) {
            this.closed = isClosed;
            if (this.s1 != null) {
                this.s1.setClosed(this.closed);
            }
            if (this.s2 != null) {
                this.s2.setClosed(!this.closed);
            }
            this.hasChanged();
        }
    }

    @Override
    public void hasChanged() {
        if (this.s1 != null) {
            this.s1.propagate();
        }
        if (this.s2 != null) {
            this.s2.propagate();
        }
    }

    @Override
    public ObservableValues getOutputs() {
        return new ObservableValues(this.outputA, this.outputB, this.outputC);
    }

    void addOutputsTo(ObservableValues.Builder ov) {
        ov.add(this.outputA, this.outputB, this.outputC);
    }

    public int getBits() {
        return this.bits;
    }
}

