/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.switching;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.NodeInterface;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.wiring.bus.BusModelStateObserver;
import de.neemann.digital.core.wiring.bus.CommonBusValue;
import de.neemann.digital.lang.Lang;

public final class PlainSwitch
implements NodeInterface {
    private final ObservableValue output1;
    private final ObservableValue output2;
    private final int bits;
    private boolean closed;
    private SwitchModel switchModel;
    private Unidirectional unidirectional = Unidirectional.NO;

    PlainSwitch(int bits, boolean closed, String out1, String out2) {
        this.bits = bits;
        this.closed = closed;
        this.output1 = new ObservableValue(out1, bits).setBidirectional().setToHighZ().setDescription(Lang.get("elem_Switch_pin", new Object[0])).setSwitchPin(true);
        this.output2 = new ObservableValue(out2, bits).setBidirectional().setToHighZ().setDescription(Lang.get("elem_Switch_pin", new Object[0])).setSwitchPin(true);
    }

    public PlainSwitch setUnidirectional(Unidirectional unidirectional) {
        this.unidirectional = unidirectional;
        return this;
    }

    public int getBits() {
        return this.bits;
    }

    public void setInputs(ObservableValue input1, ObservableValue input2) throws NodeException {
        if (input1 != null && input2 != null) {
            input1.addObserverToValue(this).checkBits(this.bits, null);
            input2.addObserverToValue(this).checkBits(this.bits, null);
            switch (this.unidirectional) {
                case NO: {
                    this.switchModel = PlainSwitch.createSwitchModel(input1, input2, this.output1, this.output2);
                    break;
                }
                case FROM1TO2: {
                    this.switchModel = new UniDirectionalSwitch(input1, this.output2);
                    break;
                }
                case FROM2TO1: {
                    this.switchModel = new UniDirectionalSwitch(input2, this.output1);
                }
            }
        }
    }

    static SwitchModel createSwitchModel(ObservableValue input1, ObservableValue input2, ObservableValue output1, ObservableValue output2) throws NodeException {
        if (input1 instanceof CommonBusValue) {
            if (input2 instanceof CommonBusValue) {
                CommonBusValue in1 = (CommonBusValue)input1;
                CommonBusValue in2 = (CommonBusValue)input2;
                ObservableValue constant = in1.searchConstant();
                if (constant != null) {
                    return new UniDirectionalSwitch(constant, output2);
                }
                constant = in2.searchConstant();
                if (constant != null) {
                    return new UniDirectionalSwitch(constant, output1);
                }
                return new RealSwitch(in1, output1, in2, output2);
            }
            return new UniDirectionalSwitch(input1, output2);
        }
        if (input2 instanceof CommonBusValue) {
            return new UniDirectionalSwitch(input2, output1);
        }
        throw new NodeException(Lang.get("err_switchHasNoNet", new Object[0]), output1, output2);
    }

    @Override
    public ObservableValues getOutputs() {
        return new ObservableValues(this.output1, this.output2);
    }

    void addOutputsTo(ObservableValues.Builder ov) {
        ov.add(this.output1, this.output2);
    }

    public void init(Model model) {
        if (this.switchModel != null) {
            this.switchModel.setModel(model);
            this.switchModel.setClosed(this.closed);
            this.hasChanged();
        }
    }

    @Override
    public void hasChanged() {
        this.switchModel.propagate();
    }

    public void setClosed(boolean closed) {
        if (this.switchModel != null && this.closed != closed) {
            this.closed = closed;
            this.switchModel.setClosed(closed);
            this.hasChanged();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    ObservableValue getOutput1() {
        return this.output1;
    }

    ObservableValue getOutput2() {
        return this.output2;
    }

    public static final class RealSwitch
    implements SwitchModel {
        private final CommonBusValue input1;
        private final ObservableValue output1;
        private final CommonBusValue input2;
        private final ObservableValue output2;
        private BusModelStateObserver obs;

        private RealSwitch(CommonBusValue input1, ObservableValue output1, CommonBusValue input2, ObservableValue output2) {
            this.input1 = input1;
            this.output1 = output1;
            this.input2 = input2;
            this.output2 = output2;
        }

        @Override
        public void propagate() {
        }

        @Override
        public void setClosed(boolean closed) {
            this.obs.setClosed(this, closed);
        }

        @Override
        public void setModel(Model model) {
            this.obs = model.getObserver(BusModelStateObserver.class);
        }

        public CommonBusValue getInput1() {
            return this.input1;
        }

        public CommonBusValue getInput2() {
            return this.input2;
        }

        public ObservableValue getOutput1() {
            return this.output1;
        }

        public ObservableValue getOutput2() {
            return this.output2;
        }
    }

    private static final class UniDirectionalSwitch
    implements SwitchModel {
        private final ObservableValue input;
        private final ObservableValue output;
        private boolean setOpenContactToHighZ;
        private boolean closed;

        UniDirectionalSwitch(ObservableValue input, ObservableValue output) {
            this.input = input;
            this.output = output;
            this.setOpenContactToHighZ = true;
        }

        @Override
        public void propagate() {
            if (this.closed) {
                this.output.set(this.input.getValue(), this.input.getHighZ());
            } else if (this.setOpenContactToHighZ) {
                this.output.setToHighZ();
            }
        }

        @Override
        public void setClosed(boolean closed) {
            this.closed = closed;
        }

        @Override
        public void setModel(Model model) {
        }

        @Override
        public void dontTouchOpenContact() {
            this.setOpenContactToHighZ = false;
        }

        @Override
        public boolean isUniDirOutput(ObservableValue out) {
            return this.output == out;
        }
    }

    static interface SwitchModel {
        public void propagate();

        public void setClosed(boolean var1);

        public void setModel(Model var1);

        default public void dontTouchOpenContact() {
        }

        default public boolean isUniDirOutput(ObservableValue out) {
            return false;
        }
    }

    public static enum Unidirectional {
        NO,
        FROM1TO2,
        FROM2TO1;

    }
}

