/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.pld;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;

public class PullDown
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription("PullDown", PullDown.class, new PinDescription[0]).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS);
    private final ObservableValue output;

    public PullDown(ElementAttributes attr) {
        int bits = attr.getBits();
        this.output = new PullObservableValue(bits, PinDescription.PullResistor.pullDown).setPinDescription(DESCRIPTION);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }

    @Override
    public void registerNodes(Model model) {
    }

    public static final class PullObservableValue
    extends ObservableValue {
        private final PinDescription.PullResistor res;

        PullObservableValue(int bits, PinDescription.PullResistor res) {
            super("out", bits);
            this.setToHighZ();
            this.res = res;
        }

        @Override
        public PinDescription.PullResistor getPullResistor() {
            return this.res;
        }
    }
}

