/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.pld;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.NodeInterface;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.wiring.bus.CommonBusValue;
import de.neemann.digital.lang.Lang;

public class DiodeForward
implements Element,
NodeInterface {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(DiodeForward.class, PinInfo.input("in")).addAttribute(Keys.ROTATE).addAttribute(Keys.BLOWN);
    private final ObservableValue output;
    private final boolean blown;
    private ObservableValue input;
    private PinDescription.PullResistor requiredResistor;

    public DiodeForward(ElementAttributes attr) {
        this(attr, DESCRIPTION, PinDescription.PullResistor.pullDown);
    }

    protected DiodeForward(ElementAttributes attr, ElementTypeDescription description, PinDescription.PullResistor requiredResistor) {
        this.output = new ObservableValue("out", 1).setToHighZ().setPinDescription(description).setBidirectional();
        this.requiredResistor = requiredResistor;
        this.blown = attr.get(Keys.BLOWN);
        if (this.blown) {
            this.output.setToHighZ();
        }
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        CommonBusValue cbv;
        this.input = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(1, null);
        ObservableValue o = (ObservableValue)inputs.get(1);
        if (o instanceof CommonBusValue && (cbv = (CommonBusValue)o).getResistor().equals((Object)this.requiredResistor)) {
            return;
        }
        if (this.requiredResistor.equals((Object)PinDescription.PullResistor.pullDown)) {
            throw new NodeException(Lang.get("err_diodeNeedsPullDownResistorAtOutput", new Object[0]), this.output.asList());
        }
        throw new NodeException(Lang.get("err_diodeNeedsPullUpResistorAtOutput", new Object[0]), this.output.asList());
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }

    @Override
    public void registerNodes(Model model) {
    }

    @Override
    public void hasChanged() {
        if (!this.blown) {
            if (this.input.isHighZ()) {
                this.output.setToHighZ();
            } else {
                boolean in = this.input.getBool();
                this.setOutValue(this.output, in);
            }
        }
    }

    protected void setOutValue(ObservableValue output, boolean in) {
        output.set(in ? 1L : 0L, in ? 0L : 1L);
    }

    @Override
    public void init(Model model) throws NodeException {
        this.hasChanged();
    }
}

