/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory.rom;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.rom.ROMInterface;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.IOException;

public abstract class ROMMangerBase {
    public void applyTo(Model model, File origin) throws NodeException {
        if (this.isEmpty()) {
            return;
        }
        for (Node n2 : model.findNode(n -> n instanceof ROMInterface)) {
            DataField data;
            ROMInterface rom = (ROMInterface)((Object)n2);
            try {
                data = this.getRom(rom.getLabel(), rom.getDataBits(), origin);
            }
            catch (IOException e) {
                throw new NodeException(Lang.get("err_could_not_load_rom", new Object[0]), e);
            }
            if (data == null) continue;
            rom.setData(data);
        }
    }

    public abstract boolean isEmpty();

    public abstract DataField getRom(String var1, int var2, File var3) throws IOException;
}

