/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory.rom;

import de.neemann.digital.FileLocator;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.importer.Importer;
import de.neemann.digital.core.memory.rom.ROMManager;
import de.neemann.digital.core.memory.rom.ROMMangerBase;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ROMManagerFile
extends ROMMangerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ROMManagerFile.class);
    private final HashMap<String, RomContainer> roms = new HashMap();

    public ROMManagerFile(ROMManager rm) {
        this();
        LOGGER.info("convert old rom manager");
        for (Map.Entry<String, DataField> df : rm.getRoms().entrySet()) {
            this.roms.put(df.getKey(), new RomContainerDataField(df.getValue()));
        }
    }

    public ROMManagerFile() {
    }

    @Override
    public boolean isEmpty() {
        return this.roms.isEmpty();
    }

    @Override
    public DataField getRom(String label, int dataBits, File origin) throws IOException {
        if (this.roms == null) {
            return null;
        }
        RomContainer rc = this.roms.get(label);
        if (rc == null) {
            return null;
        }
        return rc.getDataField(dataBits, origin);
    }

    public RomContainer getRomContainer(String label) {
        return this.roms.get(label);
    }

    public void addContainer(String label, RomContainer romContainer) {
        this.roms.put(label, romContainer);
    }

    public static final class RomContainerFile
    implements RomContainer {
        private final File romFile;
        private final boolean bigEndian;

        public RomContainerFile(File romData, boolean bigEndian) {
            this.romFile = romData;
            this.bigEndian = bigEndian;
        }

        @Override
        public DataField getDataField(int dataBits, File origin) throws IOException {
            return Importer.read(new FileLocator(this.romFile).setBaseFile(origin).locate(), dataBits, this.bigEndian);
        }

        public File getFile() {
            return this.romFile;
        }

        public boolean isBigEndian() {
            return this.bigEndian;
        }
    }

    public static final class RomContainerDataField
    implements RomContainer {
        private final DataField dataField;

        public RomContainerDataField(DataField dataField) {
            dataField.trim();
            this.dataField = new DataField(dataField);
        }

        @Override
        public DataField getDataField(int dataBits, File origin) {
            return this.dataField;
        }
    }

    public static interface RomContainer {
        public DataField getDataField(int var1, File var2) throws IOException;
    }
}

