/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory.importer;

import de.neemann.digital.core.memory.importer.ByteArray;
import de.neemann.digital.core.memory.importer.ByteArrayReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class IntelHexReader
implements ByteArrayReader {
    private final int[] data;
    private final File file;
    private int segment = 0;

    IntelHexReader(File file) {
        this.file = file;
        this.data = new int[300];
    }

    @Override
    public void read(ByteArray byteArray) throws IOException {
        try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8);){
            this.read(r, byteArray);
        }
    }

    void read(Reader reader, ByteArray byteArray) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                int payload = this.parseLine(line);
                switch (this.data[3]) {
                    case 0: {
                        this.readData(payload, byteArray);
                        break;
                    }
                    case 2: {
                        this.readDataSegment(payload);
                    }
                }
            }
        }
    }

    private void readDataSegment(int len) throws IOException {
        if (len != 2) {
            throw new IOException("invalid segment address");
        }
        this.segment = (this.data[4] << 8) + this.data[5] << 4;
    }

    private void readData(int len, ByteArray byteArray) {
        int addr = (this.data[1] << 8) + this.data[2];
        for (int i = 0; i < len; ++i) {
            byteArray.set(this.segment + addr + i, this.data[i + 4]);
        }
    }

    private int parseLine(String line) throws IOException {
        if (line.charAt(0) != ':') {
            throw new IOException("not a intel hex file");
        }
        int addr = 0;
        for (int p = 1; p < line.length(); p += 2) {
            this.data[addr] = Integer.parseInt(line.substring(p, p + 2), 16);
            ++addr;
        }
        int payload = addr - 5;
        if (payload < 0) {
            throw new IOException("not a intel hex file");
        }
        if (this.data[0] != payload) {
            throw new IOException("invalid record size");
        }
        int sum = 0;
        for (int i = 0; i < addr; ++i) {
            sum += this.data[i];
        }
        if ((sum &= 0xFF) != 0) {
            throw new IOException("wrong checksum in intel hex file: 0x" + Integer.toHexString(sum));
        }
        return payload;
    }
}

