/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory;

import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.ValueFormatter;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.RAMInterface;
import de.neemann.digital.core.memory.rom.ROMInterface;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.gui.components.CircuitModifier;
import de.neemann.digital.gui.components.modification.ModifyAttribute;

public class EEPROM
extends Node
implements Element,
RAMInterface,
ROMInterface {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(EEPROM.class, PinInfo.input("A"), PinInfo.input("CS"), PinInfo.input("WE").setClock(), PinInfo.input("OE")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.ADDR_BITS).addAttribute(Keys.LABEL).addAttribute(Keys.INT_FORMAT).addAttribute(Keys.IS_PROGRAM_MEMORY).addAttribute(Keys.INVERTER_CONFIG).addAttribute(Keys.DATA);
    private final int bits;
    private final int addrBits;
    private final ElementAttributes attr;
    private final int size;
    private final String label;
    private final ObservableValue dataOut;
    private final boolean isProgramMemory;
    private final ValueFormatter formatter;
    private DataField memory;
    private ObservableValue addrIn;
    private ObservableValue csIn;
    private ObservableValue weIn;
    private ObservableValue oeIn;
    private ObservableValue dataIn;
    private int readAddr;
    private int writeAddr;
    private boolean cs;
    private boolean oe;
    private boolean we;
    private boolean lastWrite;

    public EEPROM(ElementAttributes attr) {
        super(true);
        this.attr = attr;
        this.bits = attr.get(Keys.BITS);
        this.addrBits = attr.get(Keys.ADDR_BITS);
        this.size = 1 << this.addrBits;
        this.memory = new DataField(attr.get(Keys.DATA));
        this.label = attr.getLabel();
        this.dataOut = new ObservableValue("D", this.bits).setToHighZ().setPinDescription(DESCRIPTION).setBidirectional();
        this.isProgramMemory = attr.isProgramMemory();
        this.formatter = attr.getValueFormatter();
    }

    @Override
    public void enableCircuitModification(VisualElement visualElement, CircuitModifier circuitModifier) {
        this.getModel().addObserver(event -> {
            if (event.getType() == ModelEventType.CLOSED) {
                DataField orig = this.attr.get(Keys.DATA);
                this.memory.trim();
                if (!orig.equals(this.memory)) {
                    circuitModifier.modify(new ModifyAttribute<DataField>(visualElement, Keys.DATA, this.memory));
                }
            }
        }, ModelEventType.CLOSED, new ModelEventType[0]);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.addrIn = ((ObservableValue)inputs.get(0)).checkBits(this.addrBits, this).addObserverToValue(this);
        this.csIn = ((ObservableValue)inputs.get(1)).checkBits(1, this).addObserverToValue(this);
        this.weIn = ((ObservableValue)inputs.get(2)).checkBits(1, this).addObserverToValue(this);
        this.oeIn = ((ObservableValue)inputs.get(3)).checkBits(1, this).addObserverToValue(this);
        this.dataIn = ((ObservableValue)inputs.get(4)).checkBits(this.bits, this);
    }

    @Override
    public void readInputs() throws NodeException {
        boolean write;
        this.cs = this.csIn.getBool();
        if (this.cs) {
            this.readAddr = (int)this.addrIn.getValue();
            this.oe = this.oeIn.getBool();
        }
        this.we = this.weIn.getBool();
        boolean bl = write = this.cs && this.we;
        if (write && !this.lastWrite) {
            this.writeAddr = (int)this.addrIn.getValue();
        }
        if (!write && this.lastWrite) {
            long data = this.dataIn.getValue();
            this.memory.setData(this.writeAddr, data);
        }
        this.lastWrite = write;
    }

    @Override
    public void writeOutputs() throws NodeException {
        if (this.cs && this.oe && !this.we) {
            this.dataOut.setValue(this.memory.getDataWord(this.readAddr));
        } else {
            this.dataOut.setToHighZ();
        }
    }

    @Override
    public ValueFormatter getValueFormatter() {
        return this.formatter;
    }

    @Override
    public ObservableValues getOutputs() {
        return this.dataOut.asList();
    }

    @Override
    public DataField getMemory() {
        return this.memory;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }

    @Override
    public int getAddrBits() {
        return this.addrBits;
    }

    @Override
    public void setData(DataField data) {
        this.memory = data;
    }

    @Override
    public boolean isProgramMemory() {
        return this.isProgramMemory;
    }

    @Override
    public void setProgramMemory(DataField dataField) {
        this.memory.setDataFrom(dataField);
    }
}

