/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.memory;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.memory.ProgramCounter;

public class CounterPreset
extends Node
implements Element,
ProgramCounter {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(CounterPreset.class, PinInfo.input("en"), PinInfo.input("C").setClock(), PinInfo.input("dir"), PinInfo.input("in"), PinInfo.input("ld"), PinInfo.input("clr")).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.MAX_VALUE).addAttribute(Keys.INVERTER_CONFIG).addAttribute(Keys.LABEL).addAttribute(Keys.VALUE_IS_PROBE).addAttribute(Keys.IS_PROGRAM_COUNTER).supportsHDL();
    private final ObservableValue out;
    private final ObservableValue ovf;
    private final long maxValue;
    private final boolean probe;
    private final String label;
    private final int bits;
    private final boolean isProgramCounter;
    private ObservableValue clockIn;
    private ObservableValue clrIn;
    private ObservableValue enable;
    private ObservableValue dir;
    private ObservableValue in;
    private ObservableValue ld;
    private boolean lastClock;
    private long counter;
    private boolean ovfOut = false;

    public CounterPreset(ElementAttributes attributes) {
        super(true);
        this.bits = attributes.getBits();
        this.out = new ObservableValue("out", this.bits).setPinDescription(DESCRIPTION);
        this.ovf = new ObservableValue("ovf", 1).setPinDescription(DESCRIPTION);
        long mask = Bits.mask(this.bits);
        long m = (long)attributes.get(Keys.MAX_VALUE).intValue() & mask;
        if (m == 0L) {
            m = mask;
        }
        this.maxValue = m;
        this.probe = attributes.get(Keys.VALUE_IS_PROBE);
        this.label = attributes.getLabel();
        this.isProgramCounter = attributes.get(Keys.IS_PROGRAM_COUNTER);
    }

    @Override
    public void readInputs() throws NodeException {
        boolean clock = this.clockIn.getBool();
        boolean enable = this.enable.getBool();
        boolean dir = this.dir.getBool();
        if (clock && !this.lastClock) {
            if (enable) {
                this.counter = dir ? (this.counter == 0L ? this.maxValue : --this.counter) : (this.counter == this.maxValue ? 0L : ++this.counter);
            }
            if (this.clrIn.getBool()) {
                this.counter = 0L;
            } else if (this.ld.getBool()) {
                this.counter = this.in.getValue();
            }
        }
        this.ovfOut = this.getOvfValue(this.counter, dir, enable);
        this.lastClock = clock;
    }

    private boolean getOvfValue(long counter, boolean dir, boolean enable) {
        if (dir) {
            return counter == 0L && enable;
        }
        return counter == this.maxValue && enable;
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.ovf.setBool(this.ovfOut);
        this.out.setValue(this.counter);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws BitsException {
        this.enable = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(1, this, 0);
        this.clockIn = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(1, this, 1);
        this.dir = ((ObservableValue)inputs.get(2)).addObserverToValue(this).checkBits(1, this, 2);
        this.in = ((ObservableValue)inputs.get(3)).checkBits(this.bits, this, 3);
        this.ld = ((ObservableValue)inputs.get(4)).checkBits(1, this, 4);
        this.clrIn = ((ObservableValue)inputs.get(5)).checkBits(1, this, 5);
    }

    @Override
    public ObservableValues getOutputs() {
        return ObservableValues.ovs(this.out, this.ovf);
    }

    @Override
    public void registerNodes(Model model) {
        super.registerNodes(model);
        if (this.probe) {
            model.addSignal(new Signal(this.label, this.out, (v, z) -> {
                this.counter = v;
                boolean o = this.getOvfValue(this.counter, this.dir.getBool(), this.enable.getBool());
                this.out.setValue(this.counter);
                this.ovf.setBool(o);
            }).setTestOutput());
        }
    }

    @Override
    public boolean isProgramCounter() {
        return this.isProgramCounter;
    }

    @Override
    public long getProgramCounter() {
        return this.counter;
    }
}

