/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;

public class StepperMotorUnipolar
extends Node
implements Element {
    public static final int STEPS = 72;
    private static final int SWITCH_SIZE = 2;
    private static final boolean[] STATE_VALID = new boolean[]{false, true, true, true, true, false, true, false, true, true, false, false, true, false, false, false};
    private static final int[][] STEP_TABLE = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 2, 1, 0, 0, 0, 0, -2, -1, 0, 0, 0, 0, 0, 0}, {0, -2, 0, -1, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, -1, 1, 0, 0, 0, 2, 0, 0, -2, 0, 0, 0, 0, 0, 0}, {0, 0, -2, 0, 0, 0, -1, 0, 2, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, -1, -2, 1, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 2, 0, 0, -2, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0}, {0, 1, 0, 2, 0, 0, 0, 0, -1, 0, 0, 0, -2, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, -1, 0, -2, 0, 1, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(StepperMotorUnipolar.class, PinInfo.input("P0"), PinInfo.input("P1"), PinInfo.input("P2"), PinInfo.input("P3"), PinInfo.input("com")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.INVERT_OUTPUT);
    private final ObservableValue s0 = new ObservableValue("S0", 1).setPinDescription(DESCRIPTION);
    private final ObservableValue s1 = new ObservableValue("S1", 1).setPinDescription(DESCRIPTION);
    private final boolean invertOut;
    private ObservableValue p0;
    private ObservableValue p1;
    private ObservableValue p2;
    private ObservableValue p3;
    private ObservableValue com;
    private int lastState;
    private int pos;
    private int sequenceError;
    private boolean stateError;

    public StepperMotorUnipolar(ElementAttributes attr) {
        this.invertOut = attr.get(Keys.INVERT_OUTPUT);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.p0 = ((ObservableValue)inputs.get(0)).checkBits(1, this).addObserverToValue(this);
        this.p1 = ((ObservableValue)inputs.get(1)).checkBits(1, this).addObserverToValue(this);
        this.p2 = ((ObservableValue)inputs.get(2)).checkBits(1, this).addObserverToValue(this);
        this.p3 = ((ObservableValue)inputs.get(3)).checkBits(1, this).addObserverToValue(this);
        this.com = ((ObservableValue)inputs.get(4)).checkBits(1, this).addObserverToValue(this);
    }

    @Override
    public void readInputs() throws NodeException {
        int state = this.getState();
        int step = STEP_TABLE[this.lastState][state];
        this.pos = this.reverse() ? (this.pos -= step) : (this.pos += step);
        if (this.pos < 0) {
            this.pos += 72;
        } else if (this.pos >= 72) {
            this.pos -= 72;
        }
        boolean stateValid = STATE_VALID[state];
        if (step == 0 && STATE_VALID[this.lastState] && stateValid) {
            this.sequenceError += 8;
            if (this.sequenceError > 8) {
                this.sequenceError = 8;
            }
        } else if (this.sequenceError > 0) {
            --this.sequenceError;
        }
        boolean bl = this.stateError = state != 0 && !stateValid;
        if (stateValid) {
            this.lastState = state;
        }
    }

    protected boolean reverse() {
        return this.com.getBool();
    }

    protected int getState() {
        if (this.com.isHighZ()) {
            return 0;
        }
        boolean comIn = this.com.getBool();
        return (this.isCurrent(this.p0, comIn) ? 1 : 0) | (this.isCurrent(this.p1, comIn) ? 2 : 0) | (this.isCurrent(this.p2, comIn) ? 4 : 0) | (this.isCurrent(this.p3, comIn) ? 8 : 0);
    }

    private boolean isCurrent(ObservableValue phase, boolean comIn) {
        if (phase.isHighZ()) {
            return false;
        }
        return phase.getBool() != comIn;
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.s0.setBool(this.invertOut ^ (this.pos < 2 || this.pos > 70));
        this.s1.setBool(this.invertOut ^ (this.pos > 34 && this.pos < 38));
    }

    public int getPos() {
        return this.pos;
    }

    public boolean isError() {
        return this.sequenceError > 0 || this.stateError;
    }

    @Override
    public ObservableValues getOutputs() {
        return new ObservableValues(this.s0, this.s1);
    }
}

