/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.io;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.ValueFormatter;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.io.CommonConnectionType;
import de.neemann.digital.lang.Lang;

public class Out
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription("Out", attributes -> new Out(attributes).enforceName(), new PinDescription[]{PinInfo.input("in")}){

        @Override
        public String getDescription(ElementAttributes elementAttributes) {
            String d = Lang.evalMultilingualContent(elementAttributes.get(Keys.DESCRIPTION));
            if (d.length() > 0) {
                return d;
            }
            return super.getDescription(elementAttributes);
        }
    }.addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.LABEL).addAttribute(Keys.DESCRIPTION).addAttribute(Keys.INT_FORMAT).addAttribute(Keys.PINNUMBER).addAttribute(Keys.ADD_VALUE_TO_GRAPH).addAttribute(Keys.IN_OUT_SMALL).supportsHDL();
    public static final ElementTypeDescription LEDDESCRIPTION = new ElementTypeDescription("LED", Out.class, PinInfo.input("in")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.LED_SIZE).addAttribute(Keys.ADD_VALUE_TO_GRAPH).addAttribute(Keys.COLOR);
    public static final ElementTypeDescription POLARITYAWARELEDDESCRIPTION = new ElementTypeDescription("PolarityAwareLED", attributes -> new Out(attributes, 1, 1), PinInfo.input("A"), PinInfo.input("C")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.ADD_VALUE_TO_GRAPH).addAttribute(Keys.COLOR);
    public static final ElementTypeDescription SEVENDESCRIPTION = new SevenSegTypeDescription();
    public static final ElementTypeDescription SEVENHEXDESCRIPTION = new ElementTypeDescription("Seven-Seg-Hex", attributes -> new Out(attributes, 4, 1), PinInfo.input("d"), PinInfo.input("dp")).addAttribute(Keys.COLOR).addAttribute(Keys.SEVEN_SEG_SIZE);
    public static final ElementTypeDescription SIXTEENDESCRIPTION = new ElementTypeDescription("SixteenSeg", attributes -> new Out(attributes, 16, 1), PinInfo.input("led"), PinInfo.input("dp")).addAttribute(Keys.COLOR).addAttribute(Keys.SEVEN_SEG_SIZE);
    private final int[] bits;
    private final String label;
    private final String pinNumber;
    private final ValueFormatter formatter;
    private final boolean showInGraph;
    private boolean enforceSignal = false;
    private ObservableValue value;

    public Out(ElementAttributes attributes) {
        this.bits = new int[]{attributes.getBits()};
        this.label = attributes.getLabel();
        this.pinNumber = attributes.get(Keys.PINNUMBER);
        this.formatter = attributes.getValueFormatter();
        this.showInGraph = attributes.get(Keys.ADD_VALUE_TO_GRAPH);
    }

    public Out(ElementAttributes attributes, int ... bits) {
        this.bits = bits;
        this.label = attributes.getLabel();
        this.pinNumber = "";
        this.formatter = null;
        this.showInGraph = attributes.get(Keys.ADD_VALUE_TO_GRAPH);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        if (inputs.size() != this.bits.length) {
            throw new NodeException("wrong input count", new ObservableValue[0]);
        }
        this.value = ((ObservableValue)inputs.get(0)).checkBits(this.bits[0], null);
        for (int i = 1; i < this.bits.length; ++i) {
            ((ObservableValue)inputs.get(i)).checkBits(this.bits[i], null);
        }
    }

    @Override
    public ObservableValues getOutputs() {
        return ObservableValues.EMPTY_LIST;
    }

    @Override
    public void registerNodes(Model model) {
        Signal signal = new Signal(this.label, this.value).setPinNumber(this.pinNumber).setShowInGraph(this.showInGraph).setFormat(this.formatter);
        if (this.enforceSignal || signal.isValid()) {
            model.addOutput(signal);
        }
    }

    private Element enforceName() {
        this.enforceSignal = true;
        return this;
    }

    private static final class SevenSegTypeDescription
    extends ElementTypeDescription {
        private SevenSegTypeDescription() {
            super("Seven-Seg", (ElementAttributes attributes) -> {
                if (attributes.get(Keys.COMMON_CONNECTION).booleanValue()) {
                    return new Out(attributes, 1, 1, 1, 1, 1, 1, 1, 1, 1);
                }
                return new Out(attributes, 1, 1, 1, 1, 1, 1, 1, 1);
            }, new PinDescription[0]);
            this.addAttribute(Keys.COLOR);
            this.addAttribute(Keys.COMMON_CONNECTION);
            this.addAttribute(Keys.COMMON_CONNECTION_TYPE);
            this.addAttribute(Keys.LED_PERSIST_TIME);
        }

        @Override
        public PinDescriptions getInputDescription(ElementAttributes attributes) {
            if (attributes.get(Keys.COMMON_CONNECTION).booleanValue()) {
                if (attributes.get(Keys.COMMON_CONNECTION_TYPE).equals((Object)CommonConnectionType.anode)) {
                    return new PinDescriptions(new PinDescription[]{PinInfo.input("a"), PinInfo.input("b"), PinInfo.input("c"), PinInfo.input("d"), PinInfo.input("e"), PinInfo.input("f"), PinInfo.input("g"), PinInfo.input("dp"), PinInfo.input("ca")}).setLangKey(this.getPinLangKey());
                }
                return new PinDescriptions(new PinDescription[]{PinInfo.input("a"), PinInfo.input("b"), PinInfo.input("c"), PinInfo.input("d"), PinInfo.input("e"), PinInfo.input("f"), PinInfo.input("g"), PinInfo.input("dp"), PinInfo.input("cc")}).setLangKey(this.getPinLangKey());
            }
            return new PinDescriptions(new PinDescription[]{PinInfo.input("a"), PinInfo.input("b"), PinInfo.input("c"), PinInfo.input("d"), PinInfo.input("e"), PinInfo.input("f"), PinInfo.input("g"), PinInfo.input("dp")}).setLangKey(this.getPinLangKey());
        }
    }
}

