/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.flipflops;

import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.flipflops.FlipflopBit;

public class FlipflopRSAsync
extends FlipflopBit {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription("RS_FF_AS", FlipflopRSAsync.class, PinInfo.input("S"), PinInfo.input("R")).addAttribute(Keys.ROTATE).addAttribute(Keys.MIRROR).addAttribute(Keys.LABEL).addAttribute(Keys.DEFAULT).addAttribute(Keys.INVERTER_CONFIG).addAttribute(Keys.VALUE_IS_PROBE);
    private ObservableValue sVal;
    private ObservableValue rVal;
    private final ObservableValue qVal;
    private final ObservableValue qnVal;
    private boolean q;
    private boolean qn;

    public FlipflopRSAsync(ElementAttributes attributes) {
        super(attributes, DESCRIPTION);
        ObservableValues o = this.getOutputs();
        this.qVal = (ObservableValue)o.get(0);
        this.qnVal = (ObservableValue)o.get(1);
        this.q = this.qVal.getBool();
        this.qn = this.qnVal.getBool();
    }

    @Override
    public void readInputs() throws NodeException {
        boolean s = this.sVal.getBool();
        boolean r = this.rVal.getBool();
        if (s) {
            if (r) {
                this.q = false;
                this.qn = false;
            } else {
                this.q = true;
                this.qn = false;
            }
        } else if (r) {
            this.q = false;
            this.qn = true;
        } else if (!this.q && !this.qn) {
            if (Math.random() < 0.5) {
                this.q = true;
            } else {
                this.qn = true;
            }
        }
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.qVal.setBool(this.q);
        this.qnVal.setBool(this.qn);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws BitsException {
        this.sVal = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(1, this, 0);
        this.rVal = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(1, this, 1);
    }
}

