/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.flipflops;

import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.flipflops.FlipflopBit;

public class FlipflopJK
extends FlipflopBit {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription("JK_FF", FlipflopJK.class, PinInfo.input("J"), PinInfo.input("C").setClock(), PinInfo.input("K")).addAttribute(Keys.ROTATE).addAttribute(Keys.MIRROR).addAttribute(Keys.LABEL).addAttribute(Keys.DEFAULT).addAttribute(Keys.INVERTER_CONFIG).addAttribute(Keys.VALUE_IS_PROBE).supportsHDL();
    private ObservableValue jVal;
    private ObservableValue kVal;
    private ObservableValue clockVal;
    private boolean lastClock;

    public FlipflopJK(ElementAttributes attributes) {
        super(attributes, DESCRIPTION);
    }

    public FlipflopJK(String label, ObservableValue q, ObservableValue qn) {
        super(label, q, qn);
    }

    @Override
    public void readInputs() throws NodeException {
        boolean clock = this.clockVal.getBool();
        if (clock && !this.lastClock) {
            boolean j = this.jVal.getBool();
            boolean k = this.kVal.getBool();
            if (j && k) {
                this.setOut(!this.isOut());
            } else if (j) {
                this.setOut(true);
            } else if (k) {
                this.setOut(false);
            }
        }
        this.lastClock = clock;
    }

    @Override
    public void setInputs(ObservableValues inputs) throws BitsException {
        this.jVal = ((ObservableValue)inputs.get(0)).checkBits(1, this, 0);
        this.clockVal = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(1, this, 1);
        this.kVal = ((ObservableValue)inputs.get(2)).checkBits(1, this, 2);
    }

    public ObservableValue getjVal() {
        return this.jVal;
    }

    public ObservableValue getkVal() {
        return this.kVal;
    }

    public ObservableValue getClockVal() {
        return this.clockVal;
    }
}

