/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.flipflops;

import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;

public class FlipflopD
extends Node
implements Element,
Countable {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription("D_FF", FlipflopD.class, PinInfo.input("D"), PinInfo.input("C").setClock()).addAttribute(Keys.ROTATE).addAttribute(Keys.MIRROR).addAttribute(Keys.BITS).addAttribute(Keys.LABEL).addAttribute(Keys.DEFAULT).addAttribute(Keys.INVERTER_CONFIG).addAttribute(Keys.VALUE_IS_PROBE).supportsHDL();
    private final int bits;
    private final boolean isProbe;
    private final String label;
    private ObservableValue dVal;
    private ObservableValue clockVal;
    private ObservableValue q;
    private ObservableValue qn;
    private boolean lastClock;
    private long value;
    private long defaultValue;

    public FlipflopD(ElementAttributes attributes) {
        this(attributes, new ObservableValue("Q", attributes.getBits()).setPinDescription(DESCRIPTION), new ObservableValue("~Q", attributes.getBits()).setPinDescription(DESCRIPTION));
    }

    public FlipflopD(String label, ObservableValue q, ObservableValue qn, long def) {
        this(new ElementAttributes().set(Keys.LABEL, label).setBits(q.getBits()).set(Keys.DEFAULT, def), q, qn);
        if (qn.getBits() != q.getBits()) {
            throw new RuntimeException("wrong bit count given!");
        }
    }

    FlipflopD(ElementAttributes attributes, ObservableValue q, ObservableValue qn) {
        super(true);
        this.bits = attributes.getBits();
        this.q = q;
        this.qn = qn;
        this.isProbe = attributes.get(Keys.VALUE_IS_PROBE);
        this.label = attributes.getLabel();
        this.value = this.defaultValue = attributes.get(Keys.DEFAULT).longValue();
        q.setValue(this.value);
        qn.setValue(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void readInputs() throws NodeException {
        boolean clock = this.clockVal.getBool();
        if (clock && !this.lastClock) {
            this.value = this.dVal.getValue();
        }
        this.lastClock = clock;
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.q.setValue(this.value);
        this.qn.setValue(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws BitsException {
        this.dVal = ((ObservableValue)inputs.get(0)).checkBits(this.bits, this, 0);
        this.clockVal = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(1, this, 1);
    }

    @Override
    public ObservableValues getOutputs() {
        return ObservableValues.ovs(this.q, this.qn);
    }

    @Override
    public void registerNodes(Model model) {
        super.registerNodes(model);
        if (this.isProbe) {
            model.addSignal(new Signal(this.label, this.q, (v, z) -> {
                this.value = v;
                this.q.setValue(this.value);
                this.qn.setValue(this.value ^ 0xFFFFFFFFFFFFFFFFL);
            }).setTestOutput());
        }
    }

    public ObservableValue getDInput() {
        return this.dVal;
    }

    public String getLabel() {
        return this.label;
    }

    public ObservableValue getClock() {
        return this.clockVal;
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }

    void setValue(long value) {
        this.value = value;
    }

    public long getDefault() {
        return this.defaultValue;
    }
}

