/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.ExceptionWithOrigin;
import java.io.IOException;
import java.io.Reader;

public class VerilogTokenizer {
    private final Reader in;
    private String value;
    private boolean isUnreadChar = false;
    private int unreadChar;

    public VerilogTokenizer(Reader in) {
        this.in = in;
    }

    public Token lookEndModule() throws IOException {
        Token tk;
        try {
            while ((tk = this.nextToken()) != Token.ENDMODULE && tk != Token.EOF) {
            }
        }
        catch (TokenizerException ex) {
            tk = Token.ERROR;
        }
        return tk;
    }

    /*
     * Unable to fully structure code
     */
    public Token nextToken() throws IOException, TokenizerException {
        block17: while (true) {
            if ((ch = this.readChar()) == 47) {
                cc = this.readChar();
                switch (cc) {
                    case 42: {
                        hasAsterisk = false;
                        while (true) {
                            if ((cc = this.readChar()) == -1) {
                                throw new TokenizerException("unexpected EOF");
                            }
                            if (cc == 47 && hasAsterisk) continue block17;
                            hasAsterisk = cc == 42;
                        }
                    }
                    case 47: {
                        while (true) {
                            if (cc == 10 || cc == -1) continue block17;
                            cc = this.readChar();
                        }
                    }
                }
                this.unreadChar(cc);
            }
            this.value = "" + (char)ch;
            switch (ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block17;
                }
                case -1: {
                    return Token.EOF;
                }
                case 40: {
                    return Token.OPENPAR;
                }
                case 41: {
                    return Token.CLOSEPAR;
                }
                case 91: {
                    return Token.OPENBRACKET;
                }
                case 93: {
                    return Token.CLOSEBRACKET;
                }
                case 59: {
                    return Token.SEMICOLON;
                }
                case 58: {
                    return Token.COLON;
                }
                case 44: {
                    return Token.COMMA;
                }
                case 96: {
                    while (true) {
                        if (ch != 10 && ch != -1) ** break;
                        continue block17;
                        ch = this.readChar();
                    }
                }
                case 92: {
                    sb1 = new StringBuilder();
                    while (ch != 32 && ch != 10 && ch != -1) {
                        sb1.append((char)ch);
                        ch = this.readChar();
                    }
                    if (ch != 32) {
                        this.unreadChar(ch);
                    } else {
                        sb1.append(' ');
                    }
                    this.value = sb1.toString();
                    return Token.IDENT;
                }
            }
            break;
        }
        if (this.isNumberChar(ch)) {
            sb = new StringBuilder();
            while (this.isNumberChar(ch)) {
                sb.append((char)ch);
                ch = this.readChar();
            }
            this.unreadChar(ch);
            this.value = sb.toString();
            return Token.NUMBER;
        }
        if (this.isIdentChar(ch)) {
            sb = new StringBuilder();
            while (this.isIdentChar(ch) || this.isNumberChar(ch) || ch == 36) {
                sb.append((char)ch);
                ch = this.readChar();
            }
            this.unreadChar(ch);
            this.value = sb.toString();
            return this.lookUpKeyword(this.value);
        }
        return Token.UNKNOWN;
    }

    private Token lookUpKeyword(String str) {
        switch (str) {
            case "module": {
                return Token.MODULE;
            }
            case "input": {
                return Token.INPUT;
            }
            case "output": {
                return Token.OUTPUT;
            }
            case "inout": {
                return Token.INOUT;
            }
            case "reg": {
                return Token.REG;
            }
            case "wire": {
                return Token.WIRE;
            }
            case "endmodule": {
                return Token.ENDMODULE;
            }
        }
        return Token.IDENT;
    }

    public String value() {
        return this.value;
    }

    private int readChar() throws IOException {
        if (this.isUnreadChar) {
            this.isUnreadChar = false;
            return this.unreadChar;
        }
        return this.in.read();
    }

    private void unreadChar(int c) {
        this.unreadChar = c;
        this.isUnreadChar = true;
    }

    private boolean isIdentChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95;
    }

    private boolean isNumberChar(int c) {
        return c >= 48 && c <= 57;
    }

    public static final class TokenizerException
    extends ExceptionWithOrigin {
        private TokenizerException(String message) {
            super(message);
        }
    }

    static enum Token {
        UNKNOWN,
        MODULE,
        INPUT,
        OUTPUT,
        INOUT,
        REG,
        WIRE,
        ENDMODULE,
        EOF,
        NUMBER,
        IDENT,
        OPENPAR,
        CLOSEPAR,
        OPENBRACKET,
        CLOSEBRACKET,
        SEMICOLON,
        COLON,
        COMMA,
        ERROR;

    }
}

