/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.ExceptionWithOrigin;
import java.io.IOException;
import java.io.Reader;

public class VHDLTokenizer {
    private final Reader in;
    private Token token;
    private boolean isToken;
    private StringBuilder builder;
    private boolean isUnreadChar = false;
    private int unreadChar;

    public VHDLTokenizer(Reader in) {
        this.in = in;
        this.token = Token.UNKNOWN;
        this.isToken = false;
        this.builder = new StringBuilder();
    }

    public Token next() throws IOException, TokenizerException {
        Token token = this.peek();
        this.consume();
        return token;
    }

    public void consume() {
        this.isToken = false;
    }

    public void consume(Token t) throws TokenizerException, IOException {
        if (this.next() != t) {
            throw new TokenizerException("ident expected");
        }
    }

    public Token peek() throws IOException, TokenizerException {
        int c;
        if (this.isToken) {
            return this.token;
        }
        do {
            if ((c = this.readChar()) != 45) continue;
            int cc = this.readChar();
            if (cc == 45) {
                while ((c = this.readChar()) != 10) {
                }
                continue;
            }
            this.unreadChar(cc);
        } while (this.isWhiteSpace(c));
        switch (c) {
            case -1: {
                throw new TokenizerException("unexpected EOF");
            }
            case 40: {
                this.token = Token.OPEN;
                break;
            }
            case 41: {
                this.token = Token.CLOSE;
                break;
            }
            case 59: {
                this.token = Token.SEMICOLON;
                break;
            }
            case 44: {
                this.token = Token.COMMA;
                break;
            }
            case 58: {
                this.token = Token.COLON;
                break;
            }
            default: {
                boolean wasChar;
                if (this.isIdentChar(c)) {
                    this.token = Token.IDENT;
                    this.builder.setLength(0);
                    this.builder.append((char)c);
                    wasChar = true;
                    do {
                        if (this.isIdentChar(c = this.readChar()) || this.isNumberChar(c)) {
                            this.builder.append((char)c);
                            continue;
                        }
                        this.unreadChar(c);
                        wasChar = false;
                    } while (wasChar);
                    break;
                }
                if (this.isNumberChar(c)) {
                    this.token = Token.NUMBER;
                    this.builder.setLength(0);
                    this.builder.append((char)c);
                    wasChar = true;
                    do {
                        if (this.isNumberChar(c = this.readChar())) {
                            this.builder.append((char)c);
                            continue;
                        }
                        this.unreadChar(c);
                        wasChar = false;
                    } while (wasChar);
                    break;
                }
                this.token = Token.UNKNOWN;
                this.builder.setLength(0);
                this.builder.append((char)c);
            }
        }
        this.isToken = true;
        return this.token;
    }

    public String consumeIdent() throws IOException, TokenizerException {
        if (this.next() != Token.IDENT) {
            throw new TokenizerException("ident expected");
        }
        return this.builder.toString();
    }

    public void consumeIdent(String ident) throws IOException, TokenizerException {
        if (this.next() != Token.IDENT) {
            throw new TokenizerException("ident expected");
        }
        if (this.builder.toString().equalsIgnoreCase(ident)) {
            return;
        }
        throw new TokenizerException("ident " + ident + " expected");
    }

    public int consumeNumber() throws TokenizerException, IOException {
        if (this.next() != Token.NUMBER) {
            throw new TokenizerException("ident expected");
        }
        try {
            return Integer.parseInt(this.builder.toString());
        }
        catch (NumberFormatException e) {
            throw new TokenizerException("not a number " + this.builder.toString());
        }
    }

    public String value() {
        return this.builder.toString();
    }

    private int readChar() throws IOException {
        if (this.isUnreadChar) {
            this.isUnreadChar = false;
            return this.unreadChar;
        }
        return this.in.read();
    }

    private void unreadChar(int c) {
        this.unreadChar = c;
        this.isUnreadChar = true;
    }

    private boolean isIdentChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95;
    }

    private boolean isNumberChar(int c) {
        return c >= 48 && c <= 57;
    }

    private boolean isWhiteSpace(int c) {
        return c == 32 || c == 10 || c == 13 || c == 9;
    }

    public String toString() {
        if (this.token == Token.NUMBER || this.token == Token.IDENT || this.token == Token.UNKNOWN) {
            return this.builder.toString();
        }
        return this.token.name();
    }

    public static final class TokenizerException
    extends ExceptionWithOrigin {
        private TokenizerException(String message) {
            super(message);
        }
    }

    static enum Token {
        UNKNOWN,
        IDENT,
        OPEN,
        CLOSE,
        NUMBER,
        COMMA,
        COLON,
        SEMICOLON;

    }
}

