/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.extern.Port;
import de.neemann.digital.hdl.hgs.HGSArray;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class PortDefinition
implements Iterable<Port>,
HGSArray {
    private final ArrayList<Port> ports = new ArrayList();

    public PortDefinition(String portDescription) {
        StringTokenizer st = new StringTokenizer(portDescription, ",");
        while (st.hasMoreTokens()) {
            this.ports.add(new Port(st.nextToken().trim()));
        }
    }

    public ObservableValues createOutputs() {
        ObservableValues.Builder builder = new ObservableValues.Builder();
        for (Port p : this.ports) {
            builder.add(new ObservableValue(p.getName(), p.getBits()));
        }
        return builder.build();
    }

    public PinDescriptions getPinDescriptions(PinDescription.Direction direction) {
        PinDescription[] infos = new PinInfo[this.ports.size()];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new PinInfo(this.ports.get(i).getName(), "", direction);
        }
        return new PinDescriptions(infos);
    }

    public Port getPort(int i) {
        return this.ports.get(i);
    }

    public int getBits() {
        int bits = 0;
        for (Port p : this.ports) {
            bits += p.getBits();
        }
        return bits;
    }

    @Override
    public Iterator<Port> iterator() {
        return this.ports.iterator();
    }

    public void addPort(String name, int bits) {
        this.ports.add(new Port(name, bits));
    }

    public int size() {
        return this.ports.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Port p : this.ports) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(p.toString());
        }
        return sb.toString();
    }

    @Override
    public int hgsArraySize() {
        return this.ports.size();
    }

    @Override
    public Object hgsArrayGet(int i) {
        return this.ports.get(i);
    }
}

