/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.extern.Application;
import de.neemann.digital.core.extern.PortDefinition;
import de.neemann.digital.core.extern.handler.ProcessInterface;
import de.neemann.digital.lang.Lang;
import de.neemann.gui.ErrorMessage;
import java.io.IOException;
import javax.swing.SwingUtilities;

public class External
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(External.class, new PinDescription[0]){

        @Override
        public PinDescriptions getInputDescription(ElementAttributes elementAttributes) {
            return new PortDefinition(elementAttributes.get(Keys.EXTERNAL_INPUTS)).getPinDescriptions(PinDescription.Direction.input);
        }

        @Override
        public PinDescriptions getOutputDescriptions(ElementAttributes elementAttributes) {
            return new PortDefinition(elementAttributes.get(Keys.EXTERNAL_OUTPUTS)).getPinDescriptions(PinDescription.Direction.output);
        }
    }.addAttribute(Keys.LABEL).addAttribute(Keys.WIDTH).addAttribute(Keys.EXTERNAL_INPUTS).addAttribute(Keys.EXTERNAL_OUTPUTS).addAttribute(Keys.EXTERNAL_CODE).addAttribute(Keys.APPLICATION_TYPE).addAttribute(Keys.GHDL_OPTIONS).addAttribute(Keys.IVERILOG_OPTIONS).supportsHDL();
    private final Application.Type type;
    private final PortDefinition ins;
    private final PortDefinition outs;
    private final ElementAttributes attr;
    private final ObservableValues outputs;
    private final String label;
    private String code;
    private ObservableValues inputs;
    private ProcessInterface processInterface;

    public External(ElementAttributes attr) {
        super(true);
        this.attr = attr;
        this.ins = new PortDefinition(attr.get(Keys.EXTERNAL_INPUTS));
        this.outs = new PortDefinition(attr.get(Keys.EXTERNAL_OUTPUTS));
        this.outputs = this.outs.createOutputs();
        this.label = attr.getLabel();
        this.type = attr.get(Keys.APPLICATION_TYPE);
        this.code = attr.get(Keys.EXTERNAL_CODE);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.inputs = inputs;
        for (int i = 0; i < inputs.size(); ++i) {
            ((ObservableValue)inputs.get(i)).checkBits(this.ins.getPort(i).getBits(), this, i).addObserverToValue(this);
        }
    }

    @Override
    public void readInputs() throws NodeException {
        try {
            this.processInterface.writeValues(this.inputs);
        }
        catch (IOException e) {
            throw new NodeException(Lang.get("err_errorWritingDataToProcess", new Object[0]), this, -1, this.inputs, e);
        }
    }

    @Override
    public void writeOutputs() throws NodeException {
        try {
            this.processInterface.readValues(this.outputs);
        }
        catch (IOException e) {
            throw new NodeException(Lang.get("err_errorReadingDataFromProcess", new Object[0]), this, -1, this.outputs, e);
        }
    }

    @Override
    public ObservableValues getOutputs() {
        return this.outputs;
    }

    @Override
    public void init(Model model) throws NodeException {
        if (this.label.isEmpty()) {
            throw new NodeException(Lang.get("err_emptyLabelIsNotAllowed", new Object[0]), new ObservableValue[0]);
        }
        try {
            Application app = Application.create(this.type, this.attr);
            if (app == null) {
                throw new NodeException(Lang.get("err_errorCreatingProcess", new Object[0]), this, -1, null);
            }
            this.processInterface = app.start(this.label, this.code, this.ins, this.outs, model.getRootPath());
        }
        catch (IOException e) {
            throw new NodeException(Lang.get("err_errorCreatingProcess", new Object[0]), this, -1, null, e);
        }
        model.addObserver(event -> {
            if (event.getType().equals((Object)ModelEventType.CLOSED)) {
                try {
                    this.processInterface.close();
                }
                catch (IOException e) {
                    SwingUtilities.invokeLater(new ErrorMessage(Lang.get("msg_errorClosingExternalProcess", new Object[0])).addCause(e));
                }
            }
        }, ModelEventType.CLOSED, new ModelEventType[0]);
    }

    public void setCode(String code) {
        this.code = code;
    }
}

