/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.extern.Application;
import de.neemann.digital.core.extern.PortDefinition;
import de.neemann.digital.core.extern.VerilogTokenizer;
import de.neemann.digital.hdl.hgs.Context;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.Parser;
import de.neemann.digital.hdl.hgs.Statement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.NoSuchElementException;

public abstract class ApplicationVerilogStdIO
implements Application {
    private VerilogTokenizer.Token currToken;
    private static final Statement TEMPLATE = Parser.createFromJarStatic("verilog/VerilogStdIOTemplate.vtpl");

    public File createVerilogFile(String label, String code, PortDefinition inputs, PortDefinition outputs, File root) throws IOException {
        File dir = Files.createTempDirectory("digital_verilog_", new FileAttribute[0]).toFile();
        File file = new File(dir, label + ".v");
        try (FileWriter w = new FileWriter(file);){
            w.write(this.createVerilog(label, code, inputs, outputs, root));
        }
        catch (HGSEvalException e) {
            throw new IOException("error evaluating the template", e);
        }
        return file;
    }

    public String createVerilog(String label, String code, PortDefinition inputs, PortDefinition outputs, File root) throws HGSEvalException {
        Context context = new Context(root).declareVar("moduleName", label).declareVar("code", code).declareVar("inputs", inputs).declareVar("outputs", outputs);
        TEMPLATE.execute(context);
        return context.toString();
    }

    private void match(VerilogTokenizer.Token tkExpect, String tkText, VerilogTokenizer st) throws ParseException, IOException, VerilogTokenizer.TokenizerException {
        if (this.currToken != tkExpect) {
            throw new ParseException("unexpected '" + tkText + "'");
        }
        this.currToken = st.nextToken();
    }

    @Override
    public boolean ensureConsistency(ElementAttributes attributes, File root) {
        try {
            String code = Application.getCode(attributes, root);
            VerilogTokenizer st = new VerilogTokenizer(new StringReader(code));
            this.currToken = st.nextToken();
            this.match(VerilogTokenizer.Token.MODULE, "keyword 'module'", st);
            String label = st.value();
            this.match(VerilogTokenizer.Token.IDENT, "identifier", st);
            this.match(VerilogTokenizer.Token.OPENPAR, "'('", st);
            PortDefinition in = new PortDefinition("");
            PortDefinition out = new PortDefinition("");
            this.scanPortArgs(st, in, out);
            if (this.currToken == VerilogTokenizer.Token.SEMICOLON) {
                if (in.size() == 0 && out.size() == 0) {
                    do {
                        this.currToken = st.nextToken();
                        if (this.currToken != VerilogTokenizer.Token.INPUT && this.currToken != VerilogTokenizer.Token.OUTPUT) continue;
                        this.scanPort(st, in, out);
                    } while (this.currToken != VerilogTokenizer.Token.ENDMODULE && this.currToken != VerilogTokenizer.Token.EOF);
                }
            } else {
                return false;
            }
            if (in.size() > 0 && out.size() > 0) {
                attributes.set(Keys.LABEL, label);
                attributes.set(Keys.EXTERNAL_INPUTS, in.toString());
                attributes.set(Keys.EXTERNAL_OUTPUTS, out.toString());
                return true;
            }
            return false;
        }
        catch (ParseException | VerilogTokenizer.TokenizerException | IOException | NoSuchElementException e) {
            return false;
        }
    }

    private void scanPortArgs(VerilogTokenizer st, PortDefinition in, PortDefinition out) throws ParseException, IOException, VerilogTokenizer.TokenizerException {
        block6: while (true) {
            switch (this.currToken) {
                case IDENT: {
                    this.currToken = st.nextToken();
                    continue block6;
                }
                case INPUT: 
                case OUTPUT: {
                    this.scanPort(st, in, out);
                    continue block6;
                }
                case CLOSEPAR: {
                    this.currToken = st.nextToken();
                    return;
                }
                case COMMA: {
                    this.currToken = st.nextToken();
                    continue block6;
                }
            }
            break;
        }
        throw new ParseException("unexpected '" + st.value() + "'");
    }

    private void scanPort(VerilogTokenizer st, PortDefinition in, PortDefinition out) throws ParseException, IOException, VerilogTokenizer.TokenizerException {
        boolean isInput;
        switch (this.currToken) {
            case INPUT: {
                isInput = true;
                this.currToken = st.nextToken();
                if (this.currToken != VerilogTokenizer.Token.WIRE) break;
                this.currToken = st.nextToken();
                break;
            }
            case OUTPUT: {
                isInput = false;
                this.currToken = st.nextToken();
                if (this.currToken != VerilogTokenizer.Token.WIRE && this.currToken != VerilogTokenizer.Token.REG) break;
                this.currToken = st.nextToken();
                break;
            }
            default: {
                throw new ParseException("unexpected '" + st.value() + "'");
            }
        }
        int bits = 1;
        if (this.currToken == VerilogTokenizer.Token.OPENBRACKET) {
            this.match(VerilogTokenizer.Token.OPENBRACKET, "", st);
            String rangeStart = st.value();
            this.match(VerilogTokenizer.Token.NUMBER, "a number", st);
            this.match(VerilogTokenizer.Token.COLON, "':'", st);
            String rangeEnd = st.value();
            this.match(VerilogTokenizer.Token.NUMBER, "a number", st);
            this.match(VerilogTokenizer.Token.CLOSEBRACKET, "']'", st);
            bits = Integer.parseInt(rangeStart) - Integer.parseInt(rangeEnd) + 1;
        }
        String name = st.value();
        this.match(VerilogTokenizer.Token.IDENT, "identifier", st);
        if (isInput) {
            in.addPort(name, bits);
        } else {
            out.addPort(name, bits);
        }
        while (this.currToken == VerilogTokenizer.Token.COMMA) {
            this.match(VerilogTokenizer.Token.COMMA, "comma", st);
            if (this.currToken != VerilogTokenizer.Token.IDENT) {
                return;
            }
            name = st.value();
            this.match(VerilogTokenizer.Token.IDENT, "identifier", st);
            if (isInput) {
                in.addPort(name, bits);
                continue;
            }
            out.addPort(name, bits);
        }
    }

    private static final class ParseException
    extends Exception {
        private ParseException(String message) {
            super(message);
        }
    }
}

