/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.extern.Application;
import de.neemann.digital.core.extern.PortDefinition;
import de.neemann.digital.core.extern.VHDLTokenizer;
import de.neemann.digital.hdl.hgs.Context;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.Parser;
import de.neemann.digital.hdl.hgs.Statement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public abstract class ApplicationVHDLStdIO
implements Application {
    private static final Statement TEMPLATE = Parser.createFromJarStatic("vhdl/VHDLStdIOTemplate.tem");

    public File createVHDLFile(String label, String code, PortDefinition inputs, PortDefinition outputs, File root) throws IOException {
        File dir = Files.createTempDirectory("digital_vhdl_", new FileAttribute[0]).toFile();
        File file = new File(dir, label + ".vhdl");
        try (FileWriter w = new FileWriter(file);){
            w.write(this.createVHDL(label, code, inputs, outputs, root));
        }
        catch (HGSEvalException e) {
            throw new IOException("error evaluating the template", e);
        }
        return file;
    }

    public String createVHDL(String label, String code, PortDefinition inputs, PortDefinition outputs, File root) throws HGSEvalException {
        Context context = new Context(root).declareVar("entityName", label).declareVar("code", code).declareVar("inputs", inputs).declareVar("outputs", outputs);
        TEMPLATE.execute(context);
        return context.toString();
    }

    @Override
    public boolean ensureConsistency(ElementAttributes attributes, File rootPath) {
        try {
            String code = Application.getCode(attributes, rootPath);
            VHDLTokenizer st = new VHDLTokenizer(new StringReader(code));
            while (!st.value().equalsIgnoreCase("entity")) {
                st.next();
            }
            String label = st.consumeIdent();
            st.consumeIdent("is");
            st.consumeIdent("port");
            st.consume(VHDLTokenizer.Token.OPEN);
            PortDefinition in = new PortDefinition("");
            PortDefinition out = new PortDefinition("");
            while (true) {
                this.scanPorts(st, in, out);
                if (st.peek() != VHDLTokenizer.Token.SEMICOLON) break;
                st.consume(VHDLTokenizer.Token.SEMICOLON);
            }
            st.consume(VHDLTokenizer.Token.CLOSE);
            if (in.size() > 0 && out.size() > 0) {
                attributes.set(Keys.LABEL, label);
                attributes.set(Keys.EXTERNAL_INPUTS, in.toString());
                attributes.set(Keys.EXTERNAL_OUTPUTS, out.toString());
                return true;
            }
            return false;
        }
        catch (ParseException | VHDLTokenizer.TokenizerException | IOException | NoSuchElementException e) {
            return false;
        }
    }

    private void scanPorts(VHDLTokenizer st, PortDefinition in, PortDefinition out) throws ParseException, IOException, VHDLTokenizer.TokenizerException {
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(st.consumeIdent());
        block12: while (true) {
            switch (st.next()) {
                case COLON: {
                    switch (st.consumeIdent().toLowerCase()) {
                        case "in": {
                            this.scanPort(st, vars, in);
                            break;
                        }
                        case "out": {
                            this.scanPort(st, vars, out);
                            break;
                        }
                        default: {
                            throw new ParseException("unexpected token " + st);
                        }
                    }
                    return;
                }
                case COMMA: {
                    vars.add(st.consumeIdent());
                    continue block12;
                }
            }
            break;
        }
        throw new ParseException("unexpected token " + st);
    }

    private void scanPort(VHDLTokenizer st, ArrayList<String> vars, PortDefinition port) throws ParseException, IOException, VHDLTokenizer.TokenizerException {
        switch (st.consumeIdent().toLowerCase()) {
            case "std_logic": {
                for (String var : vars) {
                    port.addPort(var, 1);
                }
                break;
            }
            case "std_logic_vector": {
                st.consume(VHDLTokenizer.Token.OPEN);
                int upper = st.consumeNumber();
                st.consumeIdent("downto");
                int lower = st.consumeNumber();
                st.consume(VHDLTokenizer.Token.CLOSE);
                if (lower != 0) {
                    throw new ParseException("lower is not zero");
                }
                for (String var : vars) {
                    port.addPort(var, upper + 1);
                }
                break;
            }
            default: {
                throw new ParseException("unexpected token " + st);
            }
        }
    }

    private static final class ParseException
    extends Exception {
        private ParseException(String message) {
            super(message);
        }
    }
}

