/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.extern.ApplicationVerilogStdIO;
import de.neemann.digital.core.extern.Options;
import de.neemann.digital.core.extern.PortDefinition;
import de.neemann.digital.core.extern.ProcessStarter;
import de.neemann.digital.core.extern.handler.ProcessInterface;
import de.neemann.digital.core.extern.handler.StdIOInterface;
import de.neemann.digital.gui.Settings;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;

public class ApplicationIVerilog
extends ApplicationVerilogStdIO {
    private final ElementAttributes attr;
    private final boolean hasIverilog;
    private String iverilogFolder;
    private String iverilog;
    private String vvp;

    public ApplicationIVerilog(ElementAttributes attr) {
        this.attr = attr;
        this.iverilogFolder = "";
        this.hasIverilog = this.findIVerilog();
    }

    @Override
    public ProcessInterface start(String label, String code, PortDefinition inputs, PortDefinition outputs, File root) throws IOException {
        File file = null;
        if (!this.hasIverilog) {
            throw new IOException(Lang.get("err_iverilogNotInstalled", new Object[0]));
        }
        try {
            String ivlModuleDir = this.iverilogFolder + File.separator + "lib" + File.separator + "ivl";
            file = this.createVerilogFile(label, code, inputs, outputs, root);
            String testOutputName = label + ".out";
            ProcessStarter.start(file.getParentFile(), new Options().add(this.iverilog).add("-tvvp").add("-o").add(testOutputName).add(this.attr, Keys.IVERILOG_OPTIONS).add(file.getName()).getArray());
            ProcessBuilder pb = new ProcessBuilder(this.vvp, "-M", ivlModuleDir, testOutputName).redirectErrorStream(true).directory(file.getParentFile());
            return new IVerilogProcessInterface(pb.start(), file.getParentFile());
        }
        catch (IOException e) {
            if (file != null) {
                ProcessStarter.removeFolder(file.getParentFile());
            }
            if (this.iverilogNotFound(e)) {
                throw new IOException(Lang.get("err_iverilogNotInstalled", new Object[0]));
            }
            throw e;
        }
    }

    private boolean iverilogNotFound(Throwable e) {
        while (e != null) {
            if (e instanceof ProcessStarter.CouldNotStartProcessException) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    @Override
    public boolean checkSupported() {
        return true;
    }

    @Override
    public String checkCode(String label, String code, PortDefinition inputs, PortDefinition outputs, File root) throws IOException {
        File file = null;
        if (!this.hasIverilog) {
            throw new IOException(Lang.get("err_iverilogNotInstalled", new Object[0]));
        }
        try {
            file = this.createVerilogFile(label, code, inputs, outputs, root);
            String testOutputName = label + ".out";
            String string = ProcessStarter.start(file.getParentFile(), new Options().add(this.iverilog).add("-tvvp").add("-o").add(testOutputName).add(this.attr, Keys.IVERILOG_OPTIONS).add(file.getName()).getArray());
            return string;
        }
        catch (IOException e) {
            if (this.iverilogNotFound(e)) {
                throw new IOException(Lang.get("err_iverilogNotInstalled", new Object[0]));
            }
            throw e;
        }
        finally {
            if (file != null) {
                ProcessStarter.removeFolder(file.getParentFile());
            }
        }
    }

    private boolean findIVerilog() {
        Path p;
        Path ivp = null;
        File ivDir = Settings.getInstance().get(Keys.SETTINGS_IVERILOG_PATH);
        if (ivDir != null && Files.isExecutable(p = Paths.get(ivDir.getAbsolutePath(), new String[0]))) {
            ivp = p;
            if (Files.isSymbolicLink(p)) {
                try {
                    ivp = Files.readSymbolicLink(ivp);
                }
                catch (IOException ex) {
                    return false;
                }
            }
        }
        if (ivp == null) {
            String[] strPaths;
            for (String sp : strPaths = System.getenv("PATH").split(File.pathSeparator)) {
                Path p2 = Paths.get(sp, "iverilog");
                if (!Files.isExecutable(p2)) continue;
                ivp = p2;
                if (!Files.isSymbolicLink(p2)) break;
                try {
                    ivp = Files.readSymbolicLink(ivp);
                    break;
                }
                catch (IOException ex) {
                    return false;
                }
            }
        }
        if (ivp != null) {
            this.iverilogFolder = ivp.getParent().getParent().toString();
            this.iverilog = ivp.getParent().resolve("iverilog").toString();
            this.vvp = ivp.getParent().resolve("vvp").toString();
            return true;
        }
        return false;
    }

    private static final class IVerilogProcessInterface
    extends StdIOInterface {
        private final File folder;

        private IVerilogProcessInterface(Process process, File folder) {
            super(process);
            this.folder = folder;
        }

        @Override
        public String getConsoleOutNoWarn(LinkedList<String> consoleOut) {
            StringBuilder sb = new StringBuilder();
            for (String s : consoleOut) {
                if (s.contains(": warning:") || s.contains(":        :")) continue;
                sb.append(s).append("\n");
            }
            return sb.toString();
        }

        @Override
        public void close() throws IOException {
            super.close();
            ProcessStarter.removeFolder(this.folder);
        }
    }
}

