/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.extern.ApplicationVHDLStdIO;
import de.neemann.digital.core.extern.Options;
import de.neemann.digital.core.extern.PortDefinition;
import de.neemann.digital.core.extern.ProcessStarter;
import de.neemann.digital.core.extern.handler.ProcessInterface;
import de.neemann.digital.core.extern.handler.StdIOInterface;
import de.neemann.digital.gui.Settings;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;

public class ApplicationGHDL
extends ApplicationVHDLStdIO {
    private final ElementAttributes attr;

    public ApplicationGHDL(ElementAttributes attr) {
        this.attr = attr;
    }

    @Override
    public ProcessInterface start(String label, String code, PortDefinition inputs, PortDefinition outputs, File root) throws IOException {
        File file = null;
        try {
            String ghdl = ApplicationGHDL.getGhdlPath().getPath();
            file = this.createVHDLFile(label, code, inputs, outputs, root);
            ProcessStarter.start(file.getParentFile(), new Options().add(ghdl).add("-a").add(this.attr, Keys.GHDL_OPTIONS).add(file.getName()).getArray());
            ProcessStarter.start(file.getParentFile(), new Options().add(ghdl).add("-e").add(this.attr, Keys.GHDL_OPTIONS).add("stdIOInterface").getArray());
            ProcessBuilder pb = new ProcessBuilder(new Options().add(ghdl).add("-r").add(this.attr, Keys.GHDL_OPTIONS).add("stdIOInterface").add("--unbuffered").getList()).redirectErrorStream(true).directory(file.getParentFile());
            return new GHDLProcessInterface(pb.start(), file.getParentFile());
        }
        catch (IOException e) {
            if (file != null) {
                ProcessStarter.removeFolder(file.getParentFile());
            }
            if (this.ghdlNotFound(e)) {
                throw new IOException(Lang.get("err_ghdlNotInstalled", new Object[0]));
            }
            throw e;
        }
    }

    private boolean ghdlNotFound(Throwable e) {
        while (e != null) {
            if (e instanceof ProcessStarter.CouldNotStartProcessException) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    @Override
    public boolean checkSupported() {
        return true;
    }

    @Override
    public String checkCode(String label, String code, PortDefinition inputs, PortDefinition outputs, File root) throws IOException {
        File file = null;
        try {
            String ghdl = ApplicationGHDL.getGhdlPath().getPath();
            file = this.createVHDLFile(label, code, inputs, outputs, root);
            String m1 = ProcessStarter.start(file.getParentFile(), new Options().add(ghdl).add("-a").add(this.attr, Keys.GHDL_OPTIONS).add(file.getName()).getArray());
            String m2 = ProcessStarter.start(file.getParentFile(), new Options().add(ghdl).add("-e").add(this.attr, Keys.GHDL_OPTIONS).add("stdIOInterface").getArray());
            String string = ProcessStarter.joinStrings(m1, m2);
            return string;
        }
        catch (IOException e) {
            if (this.ghdlNotFound(e)) {
                throw new IOException(Lang.get("err_ghdlNotInstalled", new Object[0]));
            }
            throw e;
        }
        finally {
            if (file != null) {
                ProcessStarter.removeFolder(file.getParentFile());
            }
        }
    }

    private static File getGhdlPath() {
        return Settings.getInstance().get(Keys.SETTINGS_GHDL_PATH);
    }

    private static final class GHDLProcessInterface
    extends StdIOInterface {
        private final File folder;

        private GHDLProcessInterface(Process process, File folder) {
            super(process);
            this.folder = folder;
        }

        @Override
        public String getConsoleOutNoWarn(LinkedList<String> consoleOut) {
            StringBuilder sb = new StringBuilder();
            for (String s : consoleOut) {
                if (s.contains("(assertion warning)")) continue;
                sb.append(s).append("\n");
            }
            return sb.toString();
        }

        @Override
        public void close() throws IOException {
            super.close();
            ProcessStarter.removeFolder(this.folder);
        }
    }
}

