/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.extern;

import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.extern.ApplicationGHDL;
import de.neemann.digital.core.extern.ApplicationGeneric;
import de.neemann.digital.core.extern.ApplicationIVerilog;
import de.neemann.digital.core.extern.PortDefinition;
import de.neemann.digital.core.extern.handler.ProcessInterface;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public interface Application {
    public static String getCode(ElementAttributes attr, File root) throws IOException {
        if (attr.contains(Keys.EXTERNAL_CODE)) {
            return attr.get(Keys.EXTERNAL_CODE);
        }
        if (attr.contains(Keys.EXTERNAL_CODE_FILE)) {
            return Application.readCode(attr.getFile(Keys.EXTERNAL_CODE_FILE, root));
        }
        return "";
    }

    public static String readCode(File file) throws IOException {
        byte[] data = Files.readAllBytes(file.toPath());
        return new String(data, StandardCharsets.UTF_8);
    }

    public static Application create(Type type, ElementAttributes attr) {
        switch (type) {
            case Generic: {
                return new ApplicationGeneric();
            }
            case GHDL: {
                return new ApplicationGHDL(attr);
            }
            case IVERILOG: {
                return new ApplicationIVerilog(attr);
            }
        }
        return null;
    }

    public ProcessInterface start(String var1, String var2, PortDefinition var3, PortDefinition var4, File var5) throws IOException;

    default public boolean ensureConsistency(ElementAttributes attributes, File root) {
        return false;
    }

    default public boolean checkSupported() {
        return false;
    }

    default public String checkCode(String label, String code, PortDefinition inputs, PortDefinition outputs, File root) throws IOException {
        return null;
    }

    public static enum Type {
        Generic,
        GHDL,
        IVERILOG;

    }
}

