/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.element;

import de.neemann.digital.FileLocator;
import de.neemann.digital.core.ValueFormatter;
import de.neemann.digital.core.element.AttributeListener;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.hdl.hgs.HGSMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ElementAttributes
implements HGSMap {
    private static final String PROGRAM_MEMORY = "PROGRAM MEMORY";
    private HashMap<String, Object> attributes;
    private transient ArrayList<AttributeListener> listeners;
    private transient HashMap<String, Object> cache;

    public ElementAttributes() {
    }

    public ElementAttributes(ElementAttributes proto) {
        if (proto.attributes != null) {
            this.attributes = new HashMap();
            for (Map.Entry<String, Object> e : proto.attributes.entrySet()) {
                this.attributes.put(e.getKey(), e.getValue());
            }
        }
    }

    public <VALUE> VALUE get(Key<VALUE> key) {
        if (this.attributes == null) {
            return key.getDefault();
        }
        Object value = this.attributes.get(key.getKey());
        if (value == null) {
            return key.getDefault();
        }
        if ((key == Keys.VALUE || key == Keys.DEFAULT) && value instanceof Integer) {
            value = ((Integer)value).longValue();
            this.attributes.put(key.getKey(), value);
        }
        if (key == Keys.PINNUMBER && value instanceof Integer) {
            value = value.toString();
            this.attributes.put(key.getKey(), value);
        }
        if (key == Keys.LAST_DATA_FILE && value instanceof String) {
            value = new File(value.toString());
            this.attributes.put(key.getKey(), value);
        }
        return (VALUE)value;
    }

    public <VALUE> boolean contains(Key<VALUE> key) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(key.getKey());
    }

    public <VALUE> ElementAttributes set(Key<VALUE> key, VALUE value) {
        if (value != this.get(key)) {
            if (value.equals(key.getDefault())) {
                if (this.attributes != null) {
                    this.attributes.remove(key.getKey());
                    if (this.attributes.isEmpty()) {
                        this.attributes = null;
                    }
                }
            } else {
                if (this.attributes == null) {
                    this.attributes = new HashMap();
                }
                this.attributes.put(key.getKey(), value);
            }
            this.fireValueChanged();
        }
        return this;
    }

    private void fireValueChanged() {
        if (this.listeners != null) {
            for (AttributeListener l : this.listeners) {
                l.attributeChanged();
            }
        }
    }

    public void addListener(AttributeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(AttributeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public int getBits() {
        return this.get(Keys.BITS);
    }

    public String getLabel() {
        return this.get(Keys.LABEL);
    }

    public boolean isProgramMemory() {
        return this.getLabel().contains(PROGRAM_MEMORY) || this.get(Keys.IS_PROGRAM_MEMORY) != false;
    }

    public ValueFormatter getValueFormatter() {
        return this.get(Keys.INT_FORMAT).createFormatter(this);
    }

    public ElementAttributes setBits(int bits) {
        this.set(Keys.BITS, bits);
        return this;
    }

    public String toString() {
        return "ElementAttributes{attributes=" + this.attributes + '}';
    }

    public boolean isEmpty() {
        if (this.attributes == null) {
            return true;
        }
        return this.attributes.isEmpty();
    }

    public File getFile(Key<File> key, File root) {
        File f = this.get(key);
        if (root != null) {
            f = new FileLocator(f).setLibraryRoot(root).locate();
        }
        return f;
    }

    public File getFile(String fileKey) {
        Object f;
        if (this.attributes != null && (f = this.attributes.get(fileKey)) != null) {
            return new File(f.toString().trim());
        }
        return null;
    }

    public void setFile(String fileKey, File file) {
        if (file == null) {
            if (this.attributes != null) {
                this.attributes.remove(fileKey);
            }
        } else if (!file.equals(this.getFile(fileKey))) {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(fileKey, file.getPath());
            this.fireValueChanged();
        }
    }

    public void getValuesFrom(ElementAttributes elementAttributes) {
        if (elementAttributes == null) {
            return;
        }
        if (this.attributes != null) {
            this.attributes.clear();
        } else {
            this.attributes = new HashMap();
        }
        if (elementAttributes.attributes != null) {
            this.attributes.putAll(elementAttributes.attributes);
        }
        if (this.attributes.isEmpty()) {
            this.attributes = null;
        }
        this.fireValueChanged();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElementAttributes that = (ElementAttributes)o;
        return this.attributes != null ? this.attributes.equals(that.attributes) : that.attributes == null;
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }

    public <VALUE> boolean equalsKey(Key<VALUE> key, ElementAttributes other) {
        return this.get(key).equals(other.get(key));
    }

    public int getIntPinNumber() {
        String pin = this.get(Keys.PINNUMBER);
        try {
            return Integer.parseInt(pin);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public Object hgsMapGet(String key) {
        Key k = Keys.getKeyByName(key);
        if (k == null) {
            if (this.attributes == null) {
                return null;
            }
            return this.attributes.get(key);
        }
        return this.get(k);
    }

    public void putToCache(String key, Object value) {
        if (this.cache == null) {
            this.cache = new HashMap();
        }
        this.cache.put(key, value);
    }

    public Object getFromCache(String key) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(key);
    }

    public Object removeFromCache(String key) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.remove(key);
    }
}

