/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.basic;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;

public class Not
extends Node
implements Element,
Countable {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Not.class, PinInfo.input("in")).addAttribute(Keys.ROTATE).addAttribute(Keys.WIDE_SHAPE).addAttribute(Keys.BITS).supportsHDL();
    private final ObservableValue output;
    private final int bits;
    private ObservableValue input;
    private long value;

    public Not(ElementAttributes attributes) {
        this.bits = attributes.get(Keys.BITS);
        this.output = new ObservableValue("out", this.bits).setPinDescription(DESCRIPTION);
    }

    @Override
    public void readInputs() throws NodeException {
        this.value = this.input.getValue();
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.output.setValue(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.input = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(this.bits, this);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }

    public ObservableValue getOutput() {
        return this.output;
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }

    @Override
    public int getInputsCount() {
        return 1;
    }
}

